/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.mysql;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.gui.GUIUtils;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLProvider;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.player.FavouriteData;
import net.skinsrestorer.shared.storage.model.player.HistoryData;
import net.skinsrestorer.shared.storage.model.player.LegacyPlayerData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.ComponentString;

public class MySQLAdapter
implements StorageAdapter {
    private final MySQLProvider mysql;
    private final SettingsManager settings;
    private final SRLogger logger;
    private final SRPlugin plugin;

    @Override
    public void init() {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$1(this.resolveCacheTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$2(this.resolveCooldownTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$3(this.resolvePlayerTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$4(this.resolvePlayerHistoryTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$4(this.resolvePlayerFavouritesTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$5(this.resolvePlayerSkinTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$6(this.resolveURLSkinTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$7(this.resolveURLSkinIndexTable()), new Object[0]);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$init$8(this.resolveCustomSkinTable()), new Object[0]);
        try {
            this.migrateLegacyPlayerTable();
            this.migrateLegacySkinTable();
            this.migrateV15();
        }
        catch (IOException e) {
            this.logger.severe("Failed to migrate tables", e);
        }
    }

    private void migrateV15() {
        if (this.columnExists(this.resolveCacheTable(), "is_premium")) {
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateV15$1(this.resolveCacheTable()), new Object[0]);
        }
        if (!this.columnExists(this.resolveCustomSkinTable(), "display_name")) {
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateV15$2(this.resolveCustomSkinTable()), new Object[0]);
        }
    }

    private void migrateLegacyPlayerTable() throws IOException {
        Optional<String> legacyPlayerTable = this.getLegacyPlayerTableFile();
        if (J_U_Optional.isEmpty(legacyPlayerTable)) {
            return;
        }
        if (!this.tableExists(legacyPlayerTable.get())) {
            this.logger.info("Legacy player table to seems to no longer exist, this may be because it was already migrated! Skipping player table migration...");
            this.plugin.moveToArchive(this.getLegacyPlayerTableFilePath());
            return;
        }
        this.logger.info("Migrating legacy player table to new format...");
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacyPlayerTable$1(this.resolveLegacyPlayerTable()), new Object[0]);
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$migrateLegacyPlayerTable$2(legacyPlayerTable.get()), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("Nick");
                String skin = crs.getString("Skin");
                this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacyPlayerTable$3(this.resolveLegacyPlayerTable()), name, skin);
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to migrate legacy player table", e);
        }
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacyPlayerTable$4(legacyPlayerTable.get()), new Object[0]);
        Files.deleteIfExists(this.getLegacyPlayerTableFilePath());
        this.logger.info("Player migration complete!");
    }

    private void migrateLegacySkinTable() throws IOException {
        Optional<String> legacySkinTable = this.getLegacySkinTableFile();
        if (J_U_Optional.isEmpty(legacySkinTable)) {
            return;
        }
        if (!this.tableExists(legacySkinTable.get())) {
            this.logger.info("Legacy skin table to seems to no longer exist, this may be because it was already migrated! Skipping skin table migration...");
            this.plugin.moveToArchive(this.getLegacySkinTableFilePath());
            return;
        }
        this.logger.info("Migrating legacy skin table to new format...");
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacySkinTable$1(this.resolveLegacySkinTable()), new Object[0]);
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$migrateLegacyPlayerTable$2(legacySkinTable.get()), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("Nick");
                String value = crs.getString("Value");
                String signature = crs.getString("Signature");
                String timestampString = crs.getString("timestamp");
                if (timestampString == null || this.isLegacyCustomSkinTimestamp(Long.parseLong(timestampString))) {
                    this.setCustomSkinData(name, CustomSkinData.of(name, null, SkinProperty.of(value, signature)));
                    continue;
                }
                this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacySkinTable$2(this.resolveLegacySkinTable()), name, value, signature);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$migrateLegacySkinTable$3(legacySkinTable.get()), new Object[0]);
        Files.deleteIfExists(this.getLegacySkinTableFilePath());
        this.logger.info("Skin migration complete!");
    }

    private boolean tableExists(String table) {
        boolean bl;
        block8: {
            ResultSet rs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$tableExists$1(table), new Object[0]);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.severe("Failed to check if table exists", e);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    private boolean columnExists(String table, String column) {
        boolean bl;
        block8: {
            ResultSet rs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$columnExists$1(table, column), new Object[0]);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.severe("Failed to check if column exists", e);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<PlayerData> getPlayerData(UUID uuid) throws StorageAdapter.StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setPlayerData(UUID uuid, PlayerData data) {
        boolean hasSkin = data.getSkinIdentifier() != null;
        SkinIdentifier identifier = data.getSkinIdentifier();
        String skinIdentifierString = hasSkin ? identifier.getIdentifier() : null;
        String skinType = hasSkin ? identifier.getSkinType().name() : null;
        String skinVariant = hasSkin && identifier.getSkinVariant() != null ? identifier.getSkinVariant().name() : null;
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerData$1(this.resolvePlayerTable()), uuid.toString(), skinIdentifierString, skinType, skinVariant, skinIdentifierString, skinType, skinVariant);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerData$1(this.resolvePlayerHistoryTable(), data.getHistory().isEmpty() ? "NULL" : data.getHistory().stream().map(HistoryData::getTimestamp).map(String::valueOf).collect(Collectors.joining(", "))), uuid);
        for (HistoryData historyData : data.getHistory()) {
            SkinIdentifier historyIdentifier = historyData.getSkinIdentifier();
            String historySkinIdentifier = historyIdentifier.getIdentifier();
            String historySkinType = historyIdentifier.getSkinType().name();
            String historySkinVariant = historyIdentifier.getSkinVariant() != null ? historyIdentifier.getSkinVariant().name() : null;
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerData$2(this.resolvePlayerHistoryTable()), uuid.toString(), historyData.getTimestamp(), historySkinIdentifier, historySkinType, historySkinVariant, historySkinIdentifier, historySkinType, historySkinVariant);
        }
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerData$1(this.resolvePlayerFavouritesTable(), data.getFavourites().isEmpty() ? "NULL" : data.getFavourites().stream().map(FavouriteData::getTimestamp).map(String::valueOf).collect(Collectors.joining(", "))), uuid);
        for (FavouriteData favouriteData : data.getFavourites()) {
            SkinIdentifier favouriteIdentifier = favouriteData.getSkinIdentifier();
            String favouriteSkinIdentifier = favouriteIdentifier.getIdentifier();
            String favouriteSkinType = favouriteIdentifier.getSkinType().name();
            String favouriteSkinVariant = favouriteIdentifier.getSkinVariant() != null ? favouriteIdentifier.getSkinVariant().name() : null;
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerData$2(this.resolvePlayerFavouritesTable()), uuid.toString(), favouriteData.getTimestamp(), favouriteSkinIdentifier, favouriteSkinType, favouriteSkinVariant, favouriteSkinIdentifier, favouriteSkinType, favouriteSkinVariant);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<PlayerSkinData> getPlayerSkinData(UUID uuid) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getPlayerData$1(this.resolvePlayerSkinTable()), uuid.toString());){
            if (!crs.next()) {
                Optional<PlayerSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String lastKnownName = crs.getString("last_known_name");
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            long timestamp = crs.getLong("timestamp");
            Optional<PlayerSkinData> optional = Optional.of(PlayerSkinData.of(uuid, lastKnownName, SkinProperty.of(value, signature), timestamp));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removePlayerSkinData(UUID uuid) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removePlayerSkinData$1(this.resolvePlayerSkinTable()), uuid.toString());
    }

    @Override
    public void setPlayerSkinData(UUID uuid, PlayerSkinData skinData) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setPlayerSkinData$1(this.resolvePlayerSkinTable()), uuid.toString(), skinData.getLastKnownName(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getTimestamp(), skinData.getLastKnownName(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getTimestamp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<URLSkinData> getURLSkinData(String url, SkinVariant skinVariant) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getURLSkinData$1(this.resolveURLSkinTable()), url, skinVariant.name());){
            if (!crs.next()) {
                Optional<URLSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String mineSkinId = crs.getString("mine_skin_id");
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            SkinVariant variant = SkinVariant.valueOf(crs.getString("skin_variant"));
            Optional<URLSkinData> optional = Optional.of(URLSkinData.of(url, mineSkinId, SkinProperty.of(value, signature), variant));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinData(String url, SkinVariant skinVariant) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeURLSkinData$1(this.resolveURLSkinTable()), url, skinVariant.name());
    }

    @Override
    public void setURLSkinData(String url, URLSkinData skinData) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setURLSkinData$1(this.resolveURLSkinTable()), url, skinData.getMineSkinId(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getSkinVariant().name(), skinData.getMineSkinId(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getSkinVariant().name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<URLIndexData> getURLSkinIndex(String url) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getURLSkinIndex$1(this.resolveURLSkinIndexTable()), url);){
            if (!crs.next()) {
                Optional<URLIndexData> optional2 = Optional.empty();
                return optional2;
            }
            SkinVariant variant = SkinVariant.valueOf(crs.getString("skin_variant"));
            Optional<URLIndexData> optional = Optional.of(URLIndexData.of(url, variant));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinIndex(String url) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeURLSkinIndex$1(this.resolveURLSkinIndexTable()), url);
    }

    @Override
    public void setURLSkinIndex(String url, URLIndexData skinData) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setURLSkinIndex$1(this.resolveURLSkinIndexTable()), url, skinData.getSkinVariant().name(), skinData.getSkinVariant().name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<CustomSkinData> getCustomSkinData(String skinName) throws StorageAdapter.StorageException {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getCustomSkinData$1(this.resolveCustomSkinTable()), skinName);){
            if (!crs.next()) {
                Optional<CustomSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String displayName = crs.getString("display_name");
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            Optional<CustomSkinData> optional = Optional.of(CustomSkinData.of(skinName, displayName == null ? null : new ComponentString(displayName), SkinProperty.of(value, signature)));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeCustomSkinData(String skinName) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeCustomSkinData$1(this.resolveCustomSkinTable()), skinName);
    }

    @Override
    public void setCustomSkinData(String skinName, CustomSkinData skinData) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setCustomSkinData$1(this.resolveCustomSkinTable()), skinName, skinData.getDisplayName() == null ? null : skinData.getDisplayName().jsonString(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getDisplayName() == null ? null : skinData.getDisplayName().jsonString(), skinData.getProperty().getValue(), skinData.getProperty().getSignature());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<LegacySkinData> getLegacySkinData(String skinName) throws StorageAdapter.StorageException {
        if (!this.tableExists(this.resolveLegacySkinTable())) return Optional.empty();
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getCustomSkinData$1(this.resolveLegacySkinTable()), skinName);){
            if (!crs.next()) {
                Optional<LegacySkinData> optional2 = Optional.empty();
                return optional2;
            }
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            Optional<LegacySkinData> optional = Optional.of(LegacySkinData.of(skinName, SkinProperty.of(value, signature)));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacySkinData(String skinName) {
        if (this.tableExists(this.resolveLegacySkinTable())) {
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeCustomSkinData$1(this.resolveLegacySkinTable()), skinName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<LegacyPlayerData> getLegacyPlayerData(String playerName) throws StorageAdapter.StorageException {
        if (!this.tableExists(this.resolveLegacyPlayerTable())) return Optional.empty();
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getCustomSkinData$1(this.resolveLegacyPlayerTable()), playerName);){
            if (!crs.next()) {
                Optional<LegacyPlayerData> optional2 = Optional.empty();
                return optional2;
            }
            String skinName = crs.getString("skin_name");
            Optional<LegacyPlayerData> optional = Optional.of(LegacyPlayerData.of(playerName, skinName));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacyPlayerData(String playerName) {
        if (this.tableExists(this.resolveLegacyPlayerTable())) {
            this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeCustomSkinData$1(this.resolveLegacyPlayerTable()), playerName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getTotalCustomSkins() {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getTotalCustomSkins$1(this.getCustomSkinQuery(0, -1)), new Object[0]);){
            if (!crs.next()) return 0;
            int n = crs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.logger.warning("Failed to get total custom skins", e);
        }
        return 0;
    }

    @Override
    public List<GUIUtils.GUIRawSkinEntry> getCustomGUISkins(int offset, int limit) {
        ArrayList<GUIUtils.GUIRawSkinEntry> skins = new ArrayList<GUIUtils.GUIRawSkinEntry>();
        try (ResultSet crs = this.mysql.query(this.getCustomSkinQuery(offset, limit), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("name");
                String displayName = crs.getString("display_name");
                String value = crs.getString("value");
                skins.add(new GUIUtils.GUIRawSkinEntry(SkinIdentifier.ofCustom(name), displayName == null ? ComponentHelper.convertPlainToJson(name) : new ComponentString(displayName), PropertyUtils.getSkinTextureHash(value), J_U_List.of()));
            }
        }
        catch (SQLException e) {
            this.logger.warning("Failed to get stored skins", e);
        }
        return skins;
    }

    private String getCustomSkinQuery(int offset, int limit) {
        List<String> onlyListSkins;
        StringBuilder query = new StringBuilder("SELECT `name`, `display_name`, `value`").append(" FROM ").append(this.resolveCustomSkinTable()).append(" WHERE `name` NOT LIKE 'sr-recommendation-%'");
        if (this.settings.getProperty(GUIConfig.CUSTOM_GUI_ONLY_LIST).booleanValue() && !(onlyListSkins = this.settings.getProperty(GUIConfig.CUSTOM_GUI_LIST)).isEmpty()) {
            query.append(" AND `name` IN (");
            query.append(onlyListSkins.stream().map(CustomSkinData::sanitizeCustomSkinName).map(s -> MySQLAdapter.jvmdowngrader$concat$lambda$getPlayerSkinQuery$2$1(s)).collect(Collectors.joining(", ")));
            query.append(")");
        }
        query.append(" ORDER BY `name` ASC");
        if (limit > 0) {
            query.append(" LIMIT ").append(offset).append(", ").append(limit);
        }
        return query.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getTotalPlayerSkins() {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getTotalCustomSkins$1(this.getPlayerSkinQuery(0, -1)), new Object[0]);){
            if (!crs.next()) return 0;
            int n = crs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            this.logger.warning("Failed to get total custom skins", e);
        }
        return 0;
    }

    @Override
    public List<GUIUtils.GUIRawSkinEntry> getPlayerGUISkins(int offset, int limit) {
        ArrayList<GUIUtils.GUIRawSkinEntry> skins = new ArrayList<GUIUtils.GUIRawSkinEntry>();
        try (ResultSet crs = this.mysql.query(this.getPlayerSkinQuery(offset, limit), new Object[0]);){
            while (crs.next()) {
                String uuid = crs.getString("uuid");
                String lastKnownName = crs.getString("last_known_name");
                String value = crs.getString("value");
                skins.add(new GUIUtils.GUIRawSkinEntry(SkinIdentifier.ofPlayer(UUID.fromString(uuid)), ComponentHelper.convertPlainToJson(lastKnownName), PropertyUtils.getSkinTextureHash(value), J_U_List.of()));
            }
        }
        catch (SQLException e) {
            this.logger.warning("Failed to get stored skins", e);
        }
        return skins;
    }

    private String getPlayerSkinQuery(int offset, int limit) {
        List<String> onlyListSkins;
        StringBuilder query = new StringBuilder("SELECT `uuid`, `last_known_name`, `value`").append(" FROM ").append(this.resolvePlayerSkinTable());
        if (this.settings.getProperty(GUIConfig.PLAYERS_GUI_ONLY_LIST).booleanValue() && !(onlyListSkins = this.settings.getProperty(GUIConfig.PLAYERS_GUI_LIST)).isEmpty()) {
            query.append(" WHERE `uuid` IN (");
            query.append(onlyListSkins.stream().map(s -> s.toLowerCase(Locale.ROOT)).map(s -> MySQLAdapter.jvmdowngrader$concat$lambda$getPlayerSkinQuery$2$1(s)).collect(Collectors.joining(", ")));
            query.append(")");
        }
        query.append(" ORDER BY `uuid` ASC");
        if (limit > 0) {
            query.append(" LIMIT ").append(offset).append(", ").append(limit);
        }
        return query.toString();
    }

    @Override
    public void purgeStoredOldSkins(long targetPurgeTimestamp) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$purgeStoredOldSkins$1(this.resolvePlayerSkinTable()), targetPurgeTimestamp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<MojangCacheData> getCachedUUID(String playerName) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getCustomSkinData$1(this.resolveCacheTable()), playerName);){
            if (!crs.next()) {
                Optional<MojangCacheData> optional2 = Optional.empty();
                return optional2;
            }
            String uuidString = crs.getString("uuid");
            UUID uuid = uuidString != null ? UUID.fromString(uuidString) : null;
            long timestamp = crs.getLong("timestamp");
            Optional<MojangCacheData> optional = Optional.of(MojangCacheData.of(uuid, timestamp));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void setCachedUUID(String playerName, MojangCacheData mojangCacheData) {
        String uuid = mojangCacheData.getUniqueId().map(UUID::toString).orElse(null);
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setCachedUUID$1(this.resolveCacheTable()), playerName, uuid, mojangCacheData.getTimestamp(), uuid, mojangCacheData.getTimestamp());
    }

    @Override
    public List<UUID> getAllCooldownProfiles() throws StorageAdapter.StorageException {
        ArrayList<UUID> profiles = new ArrayList<UUID>();
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getAllCooldownProfiles$1(this.resolveCooldownTable()), new Object[0]);){
            while (crs.next()) {
                profiles.add(UUID.fromString(crs.getString("uuid")));
            }
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
        return profiles;
    }

    @Override
    public List<StorageAdapter.StorageCooldown> getCooldowns(UUID owner) throws StorageAdapter.StorageException {
        ArrayList<StorageAdapter.StorageCooldown> cooldowns = new ArrayList<StorageAdapter.StorageCooldown>();
        try (ResultSet crs = this.mysql.query(MySQLAdapter.jvmdowngrader$concat$getPlayerData$1(this.resolveCooldownTable()), owner.toString());){
            while (crs.next()) {
                String groupName = crs.getString("group_name");
                Instant creationTime = Instant.ofEpochSecond(crs.getLong("creation_time"));
                Duration duration = Duration.ofSeconds(crs.getLong("duration"));
                cooldowns.add(new StorageAdapter.StorageCooldown(owner, groupName, creationTime, duration));
            }
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
        return cooldowns;
    }

    @Override
    public void setCooldown(UUID owner, String groupName, Instant creationTime, Duration duration) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$setCooldown$1(this.resolveCooldownTable()), owner.toString(), groupName, creationTime.getEpochSecond(), duration.getSeconds(), creationTime.getEpochSecond(), duration.getSeconds());
    }

    @Override
    public void removeCooldown(UUID owner, String groupName) {
        this.mysql.update(MySQLAdapter.jvmdowngrader$concat$removeCooldown$1(this.resolveCooldownTable()), owner.toString(), groupName);
    }

    private String resolveCustomSkinTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveCustomSkinTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveURLSkinTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveURLSkinTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveURLSkinIndexTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveURLSkinIndexTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolvePlayerSkinTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolvePlayerSkinTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolvePlayerTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolvePlayerTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolvePlayerHistoryTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolvePlayerHistoryTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolvePlayerFavouritesTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolvePlayerFavouritesTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveCooldownTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveCooldownTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveCacheTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveCacheTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveLegacyPlayerTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveLegacyPlayerTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private String resolveLegacySkinTable() {
        return MySQLAdapter.jvmdowngrader$concat$resolveLegacySkinTable$1(this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX));
    }

    private Optional<String> getLegacyPlayerTableFile() {
        Path legacyTable = this.getLegacyPlayerTableFilePath();
        try {
            if (Files.exists(legacyTable, new LinkOption[0])) {
                return Optional.of(J_N_F_Files.readString(legacyTable));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getLegacySkinTableFile() {
        Path legacyTable = this.getLegacySkinTableFilePath();
        try {
            if (Files.exists(legacyTable, new LinkOption[0])) {
                return Optional.of(J_N_F_Files.readString(legacyTable));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getLegacyPlayerTableFilePath() {
        return this.plugin.getDataFolder().resolve("legacy_player_table.txt");
    }

    private Path getLegacySkinTableFilePath() {
        return this.plugin.getDataFolder().resolve("legacy_skin_table.txt");
    }

    @Inject
    @Generated
    public MySQLAdapter(MySQLProvider mysql, SettingsManager settings, SRLogger logger, SRPlugin plugin) {
        this.mysql = mysql;
        this.settings = settings;
        this.logger = logger;
        this.plugin = plugin;
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$1(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`name` VARCHAR(16) NOT NULL,`uuid` VARCHAR(36),`timestamp` BIGINT(20) NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$2(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`uuid` VARCHAR(36),`group_name` VARCHAR(36) NOT NULL,`creation_time` BIGINT(20) NOT NULL,`duration` BIGINT(20) NOT NULL,PRIMARY KEY (`uuid`, `group_name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$3(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`uuid` VARCHAR(36) NOT NULL,`skin_identifier` VARCHAR(2083),`skin_variant` VARCHAR(20),`skin_type` VARCHAR(20),PRIMARY KEY (`uuid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$4(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`uuid` VARCHAR(36) NOT NULL,`timestamp` BIGINT(20) NOT NULL,`skin_identifier` VARCHAR(2083) NOT NULL,`skin_variant` VARCHAR(20),`skin_type` VARCHAR(20) NOT NULL,PRIMARY KEY (`uuid`, `timestamp`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$5(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`uuid` VARCHAR(36) NOT NULL,`last_known_name` VARCHAR(16),`value` TEXT NOT NULL,`signature` TEXT NOT NULL,`timestamp` BIGINT(20) NOT NULL,PRIMARY KEY (`uuid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$6(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`url` VARCHAR(266) NOT NULL,`mine_skin_id` VARCHAR(36),`value` TEXT NOT NULL,`signature` TEXT NOT NULL,`skin_variant` VARCHAR(20),PRIMARY KEY (`url`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$7(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`url` VARCHAR(266) NOT NULL,`skin_variant` VARCHAR(20),PRIMARY KEY (`url`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$init$8(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`name` VARCHAR(36) NOT NULL,`display_name` TEXT,`value` TEXT NOT NULL,`signature` TEXT NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateV15$1(String string) {
        return "ALTER TABLE `" + string + "` DROP COLUMN `is_premium`";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateV15$2(String string) {
        return "ALTER TABLE `" + string + "` ADD COLUMN `display_name` TEXT";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacyPlayerTable$1(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`name` varchar(17) NOT NULL,`skin_name` varchar(19) NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacyPlayerTable$2(String string) {
        return "SELECT * FROM " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacyPlayerTable$3(String string) {
        return "INSERT INTO " + string + " (name, skin_name) VALUES (?, ?)";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacyPlayerTable$4(String string) {
        return "DROP TABLE " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacySkinTable$1(String string) {
        return "CREATE TABLE IF NOT EXISTS `" + string + "` (`name` varchar(36) NOT NULL,`value` text NOT NULL,`signature` text NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacySkinTable$2(String string) {
        return "INSERT INTO " + string + " (name, value, signature) VALUES (?, ?, ?)";
    }

    private static /* synthetic */ String jvmdowngrader$concat$migrateLegacySkinTable$3(String string) {
        return "DROP TABLE `" + string + "`";
    }

    private static /* synthetic */ String jvmdowngrader$concat$tableExists$1(String string) {
        return "SHOW TABLES LIKE '" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$columnExists$1(String string, String string2) {
        return "SHOW COLUMNS FROM `" + string + "` LIKE '" + string2 + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getPlayerData$1(String string) {
        return "SELECT * FROM " + string + " WHERE uuid=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setPlayerData$1(String string) {
        return "INSERT INTO " + string + " (uuid, skin_identifier, skin_type, skin_variant) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skin_identifier=?, skin_type=?, skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setPlayerData$1(String string, String string2) {
        return "DELETE FROM " + string + " WHERE uuid=? AND timestamp NOT IN (" + string2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setPlayerData$2(String string) {
        return "INSERT INTO " + string + " (uuid, timestamp, skin_identifier, skin_type, skin_variant) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE skin_identifier=?, skin_type=?, skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$removePlayerSkinData$1(String string) {
        return "DELETE FROM " + string + " WHERE uuid=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setPlayerSkinData$1(String string) {
        return "INSERT INTO " + string + " (uuid, last_known_name, value, signature, timestamp) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE last_known_name=?, value=?, signature=?, timestamp=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getURLSkinData$1(String string) {
        return "SELECT * FROM " + string + " WHERE url=? AND skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$removeURLSkinData$1(String string) {
        return "DELETE FROM " + string + " WHERE url=? AND skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setURLSkinData$1(String string) {
        return "INSERT INTO " + string + " (url, mine_skin_id, value, signature, skin_variant) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE mine_skin_id=?, value=?, signature=?, skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getURLSkinIndex$1(String string) {
        return "SELECT * FROM " + string + " WHERE url=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$removeURLSkinIndex$1(String string) {
        return "DELETE FROM " + string + " WHERE url=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setURLSkinIndex$1(String string) {
        return "INSERT INTO " + string + " (url, skin_variant) VALUES (?, ?) ON DUPLICATE KEY UPDATE skin_variant=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getCustomSkinData$1(String string) {
        return "SELECT * FROM " + string + " WHERE name=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$removeCustomSkinData$1(String string) {
        return "DELETE FROM " + string + " WHERE name=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setCustomSkinData$1(String string) {
        return "INSERT INTO " + string + " (name, display_name, value, signature) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE display_name=?, value=?, signature=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getTotalCustomSkins$1(String string) {
        return "SELECT COUNT(*) FROM (" + string + ") AS subquery";
    }

    private static /* synthetic */ String jvmdowngrader$concat$purgeStoredOldSkins$1(String string) {
        return "DELETE FROM " + string + " WHERE timestamp NOT LIKE 0 AND timestamp<=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setCachedUUID$1(String string) {
        return "INSERT INTO " + string + " (name, uuid, timestamp) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE uuid=?, timestamp=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAllCooldownProfiles$1(String string) {
        return "SELECT DISTINCT `uuid` FROM " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setCooldown$1(String string) {
        return "INSERT INTO " + string + " (uuid, group_name, creation_time, duration) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE creation_time=?, duration=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$removeCooldown$1(String string) {
        return "DELETE FROM " + string + " WHERE uuid=? AND group_name=?";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveCustomSkinTable$1(String string) {
        return string + "custom_skins";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveURLSkinTable$1(String string) {
        return string + "url_skins";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveURLSkinIndexTable$1(String string) {
        return string + "url_index";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolvePlayerSkinTable$1(String string) {
        return string + "player_skins";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolvePlayerTable$1(String string) {
        return string + "players";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolvePlayerHistoryTable$1(String string) {
        return string + "player_history";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolvePlayerFavouritesTable$1(String string) {
        return string + "player_favourites";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveCooldownTable$1(String string) {
        return string + "cooldowns";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveCacheTable$1(String string) {
        return string + "cache";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveLegacyPlayerTable$1(String string) {
        return string + "legacy_players";
    }

    private static /* synthetic */ String jvmdowngrader$concat$resolveLegacySkinTable$1(String string) {
        return string + "legacy_skins";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$getPlayerSkinQuery$2$1(String string) {
        return "'" + string + "'";
    }
}

