/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.util.Optional;
import net.skinsrestorer.shadow.errorprone.annotations.RestrictedApi;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.kyori.adventure.audience.Audience;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.MiniMessage;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.skinsrestorer.shared.exception.TranslatableException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class ComponentHelper {
    private static final GsonComponentSerializer GSON_COMPONENT_SERIALIZER = GsonComponentSerializer.gson();
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final MiniMessage MINI_MESSAGE_COMPONENT_SERIALIZER = MiniMessage.miniMessage();
    private static final PlainTextComponentSerializer PLAIN_COMPONENT_SERIALIZER = PlainTextComponentSerializer.plainText();

    @RestrictedApi(explanation="The method signature changes after relocation, so it shall only be used within this package", allowedOnPath=".*net/skinsrestorer/shared/.*")
    public static ComponentString parseMiniMessageToJsonString(String miniMessage, TagResolver ... resolvers) {
        return new ComponentString((String)GSON_COMPONENT_SERIALIZER.serialize(MINI_MESSAGE_COMPONENT_SERIALIZER.deserialize(miniMessage, TagResolver.resolver(resolvers))));
    }

    public static String convertJsonToLegacy(ComponentString messageJson) {
        return LEGACY_COMPONENT_SERIALIZER.serialize((Component)GSON_COMPONENT_SERIALIZER.deserialize(messageJson.jsonString()));
    }

    public static ComponentString convertComponentToJson(Component component) {
        return new ComponentString((String)GSON_COMPONENT_SERIALIZER.serialize(component));
    }

    public static Component convertJsonToComponent(ComponentString messageJson) {
        return GSON_COMPONENT_SERIALIZER.deserialize(messageJson.jsonString());
    }

    public static String convertComponentToPlain(Component component) {
        return PLAIN_COMPONENT_SERIALIZER.serialize(component);
    }

    public static ComponentString convertPlainToJson(String text) {
        return ComponentHelper.convertComponentToJson(PLAIN_COMPONENT_SERIALIZER.deserialize(text));
    }

    public static String convertJsonToPlain(ComponentString messageJson) {
        return ComponentHelper.convertComponentToPlain(ComponentHelper.convertJsonToComponent(messageJson));
    }

    public static Audience commandSenderToAudience(final SRCommandSender sender) {
        return new Audience(){

            @Override
            public void sendMessage(@NotNull Component message) {
                sender.sendMessage(ComponentHelper.convertComponentToJson(message));
            }
        };
    }

    public static void sendException(Throwable t, SRCommandSender sender, SkinsRestorerLocale locale, SRLogger logger) {
        Optional<ComponentString> message;
        if (t instanceof TranslatableException) {
            TranslatableException exception = (TranslatableException)((Object)t);
            message = exception.getMessageOptional(sender, locale);
        } else {
            logger.warning("An unexpected error occurred while executing a command", t);
            message = locale.getMessageOptional(sender, Message.ERROR_GENERIC, Placeholder.unparsed("message", SRHelpers.getRootCause(t).getMessage()));
        }
        message.ifPresent(sender::sendMessage);
    }
}

