/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Service.class, CommandType.class})
public class MetricsCounter {
    private final SettingsManager settings;
    private final Injector injector;
    private final SettingsManager settingsManager;
    private final Map<Service, AtomicInteger> serviceMap = new EnumMap<Service, AtomicInteger>(Service.class);
    private final Map<CommandType, AtomicInteger> commandeMap = new EnumMap<CommandType, AtomicInteger>(CommandType.class);

    public String usesMySQL() {
        return String.valueOf(this.settingsManager.getProperty(DatabaseConfig.MYSQL_ENABLED));
    }

    public String isProxyMode() {
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        if (serverPlugin == null) {
            return null;
        }
        return String.valueOf(serverPlugin.isProxyMode());
    }

    public Map<String, Map<String, Integer>> pluginConfig() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        this.collectConfigDiff(map, "Advanced", AdvancedConfig.class);
        this.collectConfigDiff(map, "Api", APIConfig.class);
        this.collectConfigDiff(map, "Command", CommandConfig.class);
        this.collectConfigDiff(map, "Database", DatabaseConfig.class);
        this.collectConfigDiff(map, "Dev", DevConfig.class);
        this.collectConfigDiff(map, "GUI", GUIConfig.class);
        this.collectConfigDiff(map, "Login", LoginConfig.class);
        this.collectConfigDiff(map, "Message", MessageConfig.class);
        this.collectConfigDiff(map, "Proxy", ProxyConfig.class);
        this.collectConfigDiff(map, "Storage", StorageConfig.class);
        this.collectConfigDiff(map, "Server", ServerConfig.class);
        return map;
    }

    private void collectConfigDiff(Map<String, Map<String, Integer>> map, String name, Class<?> configClass) {
        HashMap<String, Integer> configMap = new HashMap<String, Integer>();
        for (Field field : configClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Property.class.isAssignableFrom(field.getType())) continue;
            try {
                Property property = (Property)field.get(null);
                Object value = this.settings.getProperty(property);
                Object defaultValue = property.getDefaultValue();
                boolean notDefault = !Objects.equals(value, defaultValue);
                configMap.put(property.getPath(), notDefault ? 1 : 0);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        map.put(name, configMap);
    }

    public Map<String, Integer> skinCommand() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CommandType commandType : CommandType.values()) {
            map.put(commandType.name().toLowerCase(Locale.ROOT).replace("skin_", ""), this.collect(commandType));
        }
        return map;
    }

    public void increment(CommandType commandType) {
        this.getOrCreate(commandType).incrementAndGet();
    }

    public int collect(CommandType commandType) {
        return this.getOrCreate(commandType).getAndSet(0);
    }

    private AtomicInteger getOrCreate(CommandType commandType) {
        return this.commandeMap.computeIfAbsent(commandType, k -> new AtomicInteger());
    }

    public void increment(Service service) {
        this.getOrCreate(service).incrementAndGet();
    }

    public int collect(Service service) {
        return this.getOrCreate(service).getAndSet(0);
    }

    private AtomicInteger getOrCreate(Service service) {
        return this.serviceMap.computeIfAbsent(service, k -> new AtomicInteger());
    }

    @Inject
    @Generated
    public MetricsCounter(SettingsManager settings, Injector injector, SettingsManager settingsManager) {
        this.settings = settings;
        this.injector = injector;
        this.settingsManager = settingsManager;
    }

    @NestHost(value=MetricsCounter.class)
    public static enum CommandType {
        SKIN_ROOT_HELP,
        SKIN_HELP,
        SKIN_SET,
        SKIN_CLEAR,
        SKIN_RANDOM,
        SKIN_SEARCH,
        SKIN_EDIT,
        SKIN_UPDATE,
        SKIN_URL,
        SKIN_UNDO,
        SKIN_HISTORY,
        SKIN_FAVOURITE,
        SKIN_FAVOURITES,
        SKIN_GUI;

    }

    @NestHost(value=MetricsCounter.class)
    public static enum Service {
        MINESKIN_CALLS,
        MOJANG_UUID,
        MOJANG_PROFILE,
        ECLIPSE_UUID,
        ECLIPSE_PROFILE;

    }
}

