/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import lombok.Generated;
import net.skinsrestorer.miniplaceholders.SRMiniPlaceholdersAPIExpansion;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRProxyPlatformInit;
import net.skinsrestorer.velocity.SRVelocityAdapter;
import net.skinsrestorer.velocity.SkinApplierVelocity;
import net.skinsrestorer.velocity.listener.AdminInfoListener;
import net.skinsrestorer.velocity.listener.GameProfileRequest;
import net.skinsrestorer.velocity.listener.ProxyMessageListener;
import net.skinsrestorer.velocity.wrapper.WrapperVelocity;

public class SRVelocityInit
implements SRProxyPlatformInit {
    private final Injector injector;
    private final SRLogger logger;
    private final SRVelocityAdapter adapter;
    private final SRPlugin plugin;
    private final ProxyServer proxy;
    private final WrapperVelocity wrapper;

    @Override
    public void initSkinApplier() {
        this.plugin.registerSkinApplier(this.injector.getSingleton(SkinApplierVelocity.class), Player.class, this.wrapper);
    }

    @Override
    public void initLoginProfileListener() {
        this.proxy.getEventManager().register((Object)this.adapter.pluginInstance(), (Object)this.injector.newInstance(GameProfileRequest.class));
    }

    @Override
    public void initAdminInfoListener() {
        this.proxy.getEventManager().register((Object)this.adapter.pluginInstance(), (Object)this.injector.newInstance(AdminInfoListener.class));
    }

    @Override
    public void initMessageChannel() {
        this.proxy.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"sr:messagechannel")});
        this.proxy.getEventManager().register((Object)this.adapter.pluginInstance(), PluginMessageEvent.class, (EventHandler)this.injector.getSingleton(ProxyMessageListener.class));
    }

    @Override
    public void placeholderSetupHook() {
        if (this.adapter.getPluginInfo("miniplaceholders").isPresent()) {
            try {
                new SRMiniPlaceholdersAPIExpansion<Player>(this.adapter, Player.class, this.wrapper::player).register();
                this.logger.info("MiniPlaceholders expansion registered!");
            }
            catch (Throwable t) {
                this.logger.severe("Failed to load MiniPlaceholders expansion! Please check if both SkinsRestorer and MiniPlaceholders are up-to-date.", t);
            }
        }
    }

    @Inject
    @Generated
    public SRVelocityInit(Injector injector, SRLogger logger, SRVelocityAdapter adapter, SRPlugin plugin, ProxyServer proxy, WrapperVelocity wrapper) {
        this.injector = injector;
        this.logger = logger;
        this.adapter = adapter;
        this.plugin = plugin;
        this.proxy = proxy;
        this.wrapper = wrapper;
    }
}

