/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.EnumSet;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.features.injection.NettyPipelineInjector;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class BukkitPipelineInjector
extends NettyPipelineInjector {
    private static final EnumSet<ProtocolVersion> paperNativeVersions = EnumSet.of(ProtocolVersion.V1_20_5, new ProtocolVersion[]{ProtocolVersion.V1_20_6, ProtocolVersion.V1_21, ProtocolVersion.V1_21_1, ProtocolVersion.V1_21_2, ProtocolVersion.V1_21_3});
    private static FunctionWithException<BukkitTabPlayer, Channel> getChannel;

    public BukkitPipelineInjector() {
        super("packet_handler");
    }

    public static void tryLoad(@NotNull ProtocolVersion serverVersion) {
        try {
            if (ReflectionUtils.classExists("org.bukkit.craftbukkit.CraftServer") && paperNativeVersions.contains((Object)serverVersion)) {
                getChannel = (FunctionWithException)Class.forName("me.neznamy.tab.platforms.paper.PaperLoader").getDeclaredField("getChannel").get(null);
                return;
            }
            Class<?> NetworkManager = BukkitReflection.getClass("network.Connection", "network.NetworkManager", "NetworkManager");
            Class<?> PlayerConnection = BukkitReflection.getClass("server.network.ServerGamePacketListenerImpl", "server.network.PlayerConnection", "PlayerConnection");
            Class<?> EntityPlayer = BukkitReflection.getClass("server.level.ServerPlayer", "server.level.EntityPlayer", "EntityPlayer");
            Field PLAYER_CONNECTION = ReflectionUtils.getOnlyField(EntityPlayer, PlayerConnection);
            Field NETWORK_MANAGER = BukkitReflection.is1_20_2Plus() ? ReflectionUtils.getOnlyField(PlayerConnection.getSuperclass(), NetworkManager) : ReflectionUtils.getOnlyField(PlayerConnection, NetworkManager);
            Field CHANNEL = ReflectionUtils.getOnlyField(NetworkManager, Channel.class);
            getChannel = player -> (Channel)CHANNEL.get(NETWORK_MANAGER.get(PLAYER_CONNECTION.get(player.getHandle())));
        }
        catch (Exception e) {
            BukkitUtils.compatibilityError(e, "network channel injection", null, "Anti-override for tablist & nametags not working", "Compatibility with nickname plugins changing player names will not work", "Scoreboard will not be checking for other plugins");
        }
    }

    public static boolean isAvailable() {
        return getChannel != null;
    }

    @Override
    @NotNull
    protected Channel getChannel(@NotNull TabPlayer player) {
        return getChannel.apply((BukkitTabPlayer)player);
    }

    public static void setGetChannel(FunctionWithException<BukkitTabPlayer, Channel> getChannel) {
        BukkitPipelineInjector.getChannel = getChannel;
    }
}

