/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import me.neznamy.tab.platforms.bukkit.hook.LibsDisguisesHook;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.nms.PingRetriever;
import me.neznamy.tab.platforms.bukkit.platform.BukkitPlatform;
import me.neznamy.tab.platforms.bukkit.tablist.TabListBase;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitTabPlayer
extends BackendTabPlayer {
    @NotNull
    private final Object handle;
    @Nullable
    public Object connection;

    public BukkitTabPlayer(@NotNull BukkitPlatform platform, @NotNull Player p) {
        super(platform, p, p.getUniqueId(), p.getName(), p.getWorld().getName(), platform.getServerVersion().getNetworkId());
        this.handle = BukkitReflection.CraftPlayer_getHandle.invoke((Object)p, new Object[0]);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return PingRetriever.getPing(this);
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage(this.getPlatform().toBukkitFormat(message, this.getVersion().supportsRGB()));
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return this.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public boolean isDisguised() {
        return LibsDisguisesHook.isDisguised(this);
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        return ((TabListBase)this.getTabList()).getSkin();
    }

    @NotNull
    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public BukkitPlatform getPlatform() {
        return (BukkitPlatform)this.platform;
    }

    @Override
    public boolean isVanished0() {
        for (MetadataValue v : this.getPlayer().getMetadata("vanished")) {
            if (!v.asBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getGamemode() {
        return this.getPlayer().getGameMode().getValue();
    }

    @Override
    public double getHealth() {
        return this.getPlayer().getHealth();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.getPlayer().getDisplayName();
    }

    @NotNull
    public Object getHandle() {
        return this.handle;
    }
}

