/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.bossbar;

import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.decorators.SafeBossBar;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BossBar;
import org.jetbrains.annotations.NotNull;

public class BukkitBossBar
extends SafeBossBar<BossBar> {
    private static final org.bukkit.boss.BarStyle[] styles = org.bukkit.boss.BarStyle.values();
    @NotNull
    private final BukkitTabPlayer player;

    @Override
    @NotNull
    public BossBar constructBossBar(@NotNull TabComponent title, float progress, @NotNull BarColor color, @NotNull BarStyle style) {
        BossBar bar = Bukkit.createBossBar((String)this.player.getPlatform().toBukkitFormat(title, this.player.getVersion().supportsRGB()), (org.bukkit.boss.BarColor)org.bukkit.boss.BarColor.valueOf((String)color.name()), (org.bukkit.boss.BarStyle)styles[style.ordinal()], (BarFlag[])new BarFlag[0]);
        bar.setProgress((double)progress);
        return bar;
    }

    @Override
    public void create(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).addPlayer(this.player.getPlayer());
    }

    @Override
    public void updateTitle(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).setTitle(this.player.getPlatform().toBukkitFormat(bar.getTitle(), this.player.getVersion().supportsRGB()));
    }

    @Override
    public void updateProgress(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).setProgress((double)bar.getProgress());
    }

    @Override
    public void updateStyle(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).setStyle(styles[bar.getStyle().ordinal()]);
    }

    @Override
    public void updateColor(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).setColor(org.bukkit.boss.BarColor.valueOf((String)bar.getColor().name()));
    }

    @Override
    public void remove(@NotNull SafeBossBar.BossBarInfo bar) {
        ((BossBar)bar.getBossBar()).removePlayer(this.player.getPlayer());
    }

    public BukkitBossBar(@NotNull BukkitTabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }
}

