/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms;

import java.lang.reflect.Method;
import java.util.Arrays;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class BukkitReflection {
    private static final String CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    public static final Method CraftPlayer_getHandle = BukkitReflection.getHandle();
    private static final ServerVersion serverVersion = BukkitReflection.detectServerVersion();
    private static final boolean is1_20_2Plus = ReflectionUtils.classExists("net.minecraft.world.scores.DisplaySlot");
    private static final boolean is1_20_3Plus = ReflectionUtils.classExists("net.minecraft.network.protocol.game.ClientboundResetScorePacket");
    private static final boolean is1_21_4Plus = ServerVersion.access$000(serverVersion) >= 21 && ReflectionUtils.getFields(BukkitReflection.getClass("network.chat.Style", "network.chat.ChatModifier"), Integer.class).size() == 1;

    @NotNull
    private static Method getHandle() {
        return Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
    }

    private static ServerVersion detectServerVersion() {
        int minorVersion;
        FunctionWithException<String, Class<?>> classFunction = name -> Class.forName("net.minecraft." + name);
        String[] array = CRAFTBUKKIT_PACKAGE.split("\\.");
        if (array.length > 3) {
            String serverPackage = array[3];
            minorVersion = Integer.parseInt(serverPackage.split("_")[1]);
            if (minorVersion < 17) {
                ClassLoader loader = BukkitReflection.class.getClassLoader();
                classFunction = name -> loader.loadClass("net.minecraft.server." + serverPackage + "." + name);
            }
        } else {
            minorVersion = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].split("\\.")[1]);
        }
        return new ServerVersion(classFunction, minorVersion);
    }

    public static int getMinorVersion() {
        return serverVersion.getMinorVersion();
    }

    public static Class<?> getClass(String ... names) {
        for (String name : names) {
            try {
                return (Class)serverVersion.getClass.apply(name);
            }
            catch (ClassNotFoundException | NullPointerException exception) {
            }
        }
        throw new ClassNotFoundException("No class found with possible names " + Arrays.toString(names));
    }

    public static boolean is1_20_2Plus() {
        return is1_20_2Plus;
    }

    public static boolean is1_20_3Plus() {
        return is1_20_3Plus;
    }

    public static boolean is1_21_4Plus() {
        return is1_21_4Plus;
    }

    private static class ServerVersion {
        private final FunctionWithException<String, Class<?>> getClass;
        private final int minorVersion;

        public ServerVersion(FunctionWithException<String, Class<?>> getClass, int minorVersion) {
            this.getClass = getClass;
            this.minorVersion = minorVersion;
        }

        public FunctionWithException<String, Class<?>> getGetClass() {
            return this.getClass;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        static /* synthetic */ int access$000(ServerVersion x0) {
            return x0.minorVersion;
        }
    }
}

