/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.platform;

import java.io.File;
import me.clip.placeholderapi.PlaceholderAPI;
import me.neznamy.tab.libs.org.bstats.bukkit.Metrics;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.bukkit.BukkitEventListener;
import me.neznamy.tab.platforms.bukkit.BukkitPipelineInjector;
import me.neznamy.tab.platforms.bukkit.BukkitTabCommand;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.bossbar.BukkitBossBar;
import me.neznamy.tab.platforms.bukkit.bossbar.ViaBossBar;
import me.neznamy.tab.platforms.bukkit.features.BukkitTabExpansion;
import me.neznamy.tab.platforms.bukkit.features.PerWorldPlayerList;
import me.neznamy.tab.platforms.bukkit.header.HeaderFooter;
import me.neznamy.tab.platforms.bukkit.hook.BukkitPremiumVanishHook;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.nms.PingRetriever;
import me.neznamy.tab.platforms.bukkit.nms.converter.ComponentConverter;
import me.neznamy.tab.platforms.bukkit.scoreboard.ScoreboardLoader;
import me.neznamy.tab.platforms.bukkit.tablist.TabListBase;
import me.neznamy.tab.shared.GroupManager;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.hook.LuckPermsHook;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.placeholders.types.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.impl.AdventureBossBar;
import me.neznamy.tab.shared.platform.impl.DummyBossBar;
import me.neznamy.tab.shared.util.PerformanceUtil;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.audience.Audience;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitPlatform
implements BackendPlatform {
    @NotNull
    private final JavaPlugin plugin;
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(Bukkit.getBukkitVersion().split("-")[0]);
    private final boolean placeholderAPI = ReflectionUtils.classExists("me.clip.placeholderapi.PlaceholderAPI");
    private double[] recentTps;
    private final boolean paperTps = ReflectionUtils.methodExists(Bukkit.class, "getTPS", new Class[0]);
    private final boolean paperMspt = ReflectionUtils.methodExists(Bukkit.class, "getAverageTickTime", new Class[0]);

    public BukkitPlatform(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        long time = System.currentTimeMillis();
        try {
            Object server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            this.recentTps = (double[])server.getClass().getField("recentTps").get(server);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PremiumVanish")) {
            new BukkitPremiumVanishHook().register();
        }
        PingRetriever.tryLoad();
        ComponentConverter.tryLoad(this.serverVersion);
        ScoreboardLoader.findInstance(this.serverVersion);
        TabListBase.findInstance(this.serverVersion);
        if (BukkitReflection.getMinorVersion() >= 8) {
            HeaderFooter.findInstance();
            BukkitPipelineInjector.tryLoad(this.serverVersion);
        }
        BukkitUtils.sendCompatibilityMessage();
        Bukkit.getConsoleSender().sendMessage("[TAB] " + (Object)((Object)EnumChatFormat.GRAY) + "Loaded NMS hook in " + (System.currentTimeMillis() - time) + "ms");
    }

    @Override
    public void loadPlayers() {
        for (Player p : BukkitUtils.getOnlinePlayers()) {
            TAB.getInstance().addPlayer(new BukkitTabPlayer(this, p));
        }
    }

    @Override
    public void registerPlaceholders() {
        RegisteredServiceProvider rspChat;
        PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
        manager.registerServerPlaceholder("%vault-prefix%", -1, () -> "");
        manager.registerServerPlaceholder("%vault-suffix%", -1, () -> "");
        if (Bukkit.getPluginManager().isPluginEnabled("Vault") && (rspChat = Bukkit.getServicesManager().getRegistration(Chat.class)) != null) {
            Chat chat = (Chat)rspChat.getProvider();
            int refresh = TAB.getInstance().getConfiguration().getConfig().getPermissionRefreshInterval();
            manager.registerPlayerPlaceholder("%vault-prefix%", refresh, p -> chat.getPlayerPrefix((Player)p.getPlayer()));
            manager.registerPlayerPlaceholder("%vault-suffix%", refresh, p -> chat.getPlayerSuffix((Player)p.getPlayer()));
        }
        manager.registerPlayerPlaceholder("%player_ping%", manager.getRefreshInterval("%player_ping%"), p -> PerformanceUtil.toString(((TabPlayer)p).getPing()));
        BackendPlatform.super.registerPlaceholders();
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return BukkitReflection.getMinorVersion() >= 8 && BukkitPipelineInjector.isAvailable() ? new BukkitPipelineInjector() : null;
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        if (this.placeholderAPI) {
            BukkitTabExpansion expansion = new BukkitTabExpansion();
            expansion.register();
            return expansion;
        }
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return new PerWorldPlayerList(this.plugin, configuration);
    }

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        if (!this.placeholderAPI) {
            this.registerDummyPlaceholder(identifier);
            return;
        }
        PlaceholderManagerImpl pl = TAB.getInstance().getPlaceholderManager();
        int refresh = pl.getRefreshInterval(identifier);
        if (identifier.startsWith("%rel_")) {
            TAB.getInstance().getPlaceholderManager().registerRelationalPlaceholder(identifier, pl.getRefreshInterval(identifier), (viewer, target) -> PlaceholderAPI.setRelationalPlaceholders((Player)((Player)viewer.getPlayer()), (Player)((Player)target.getPlayer()), (String)identifier));
        } else if (identifier.startsWith("%sync:")) {
            this.registerSyncPlaceholder(identifier, refresh);
        } else if (identifier.startsWith("%server_")) {
            TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(identifier, refresh, () -> PlaceholderAPI.setPlaceholders(null, (String)identifier));
        } else {
            TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(identifier, refresh, p -> PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)identifier));
        }
    }

    public void registerSyncPlaceholder(@NotNull String identifier, int refresh) {
        PlayerPlaceholderImpl[] ppl;
        String syncedPlaceholder = "%" + identifier.substring(6);
        ppl = new PlayerPlaceholderImpl[]{TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(identifier, refresh, p -> {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                long time = System.nanoTime();
                ppl[0].updateValue((me.neznamy.tab.api.TabPlayer)p, this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)syncedPlaceholder) : identifier);
                TAB.getInstance().getCPUManager().addPlaceholderTime(identifier, System.nanoTime() - time);
            });
            return null;
        })};
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        Bukkit.getConsoleSender().sendMessage("[TAB] " + this.toBukkitFormat(message, true));
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        Bukkit.getConsoleSender().sendMessage((Object)((Object)EnumChatFormat.RED) + "[TAB] [WARN] " + this.toBukkitFormat(message, true));
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Bukkit] " + Bukkit.getName() + " - " + Bukkit.getBukkitVersion().split("-")[0];
    }

    @Override
    public void registerListener() {
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitEventListener(), (Plugin)this.plugin);
    }

    @Override
    public void registerCommand() {
        PluginCommand command = Bukkit.getPluginCommand((String)"tab");
        if (command != null) {
            BukkitTabCommand cmd = new BukkitTabCommand();
            command.setExecutor((CommandExecutor)cmd);
            command.setTabCompleter((TabCompleter)cmd);
        } else {
            this.logWarn(TabComponent.fromColoredText("Failed to register command, is it defined in plugin.yml?"));
        }
    }

    @Override
    public void startMetrics() {
        Metrics metrics = new Metrics((Plugin)this.plugin, 5304);
        metrics.addCustomChart(new SimplePie("permission_system", () -> TAB.getInstance().getGroupManager().getPermissionPlugin()));
        metrics.addCustomChart(new SimplePie("server_version", () -> "1." + BukkitReflection.getMinorVersion() + ".x"));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @NotNull
    public Object convertComponent(@NotNull TabComponent component, boolean modern) {
        if (ComponentConverter.INSTANCE != null) {
            return ComponentConverter.INSTANCE.convert(component, modern);
        }
        return component;
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return ScoreboardLoader.getInstance().apply((BukkitTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        if (AdventureBossBar.isAvailable() && Audience.class.isAssignableFrom(Player.class)) {
            return new AdventureBossBar(player);
        }
        if (BukkitReflection.getMinorVersion() >= 9) {
            return new BukkitBossBar((BukkitTabPlayer)player);
        }
        if (player.getVersion().getMinorVersion() >= 9) {
            return new ViaBossBar((BukkitTabPlayer)player);
        }
        return new DummyBossBar();
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return TabListBase.getInstance().apply((BukkitTabPlayer)player);
    }

    @Override
    public boolean supportsNumberFormat() {
        return this.serverVersion.getNetworkId() >= ProtocolVersion.V1_20_3.getNetworkId();
    }

    @Override
    public boolean supportsListOrder() {
        return this.serverVersion.getNetworkId() >= ProtocolVersion.V1_21_2.getNetworkId();
    }

    @Override
    @NotNull
    public GroupManager detectPermissionPlugin() {
        RegisteredServiceProvider provider;
        if (LuckPermsHook.getInstance().isInstalled()) {
            return new GroupManager("LuckPerms", LuckPermsHook.getInstance().getGroupFunction());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Vault") && (provider = Bukkit.getServicesManager().getRegistration(Permission.class)) != null && !((Permission)provider.getProvider()).getName().equals("SuperPerms")) {
            return new GroupManager(((Permission)provider.getProvider()).getName(), p -> ((Permission)provider.getProvider()).getPrimaryGroup((Player)p.getPlayer()));
        }
        return new GroupManager("None", p -> "NONE");
    }

    @Override
    public double getTPS() {
        if (this.recentTps != null) {
            return this.recentTps[0];
        }
        if (this.paperTps) {
            return Bukkit.getTPS()[0];
        }
        return -1.0;
    }

    @Override
    public double getMSPT() {
        if (this.paperMspt) {
            return Bukkit.getAverageTickTime();
        }
        return -1.0;
    }

    public void runSync(@NotNull Entity entity, @NotNull Runnable task) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
    }

    @NotNull
    public String toBukkitFormat(@NotNull TabComponent component, boolean rgbClient) {
        if (component instanceof SimpleComponent) {
            return component.toLegacyText();
        }
        StructuredComponent iComponent = (StructuredComponent)component;
        StringBuilder sb = new StringBuilder();
        if (iComponent.getModifier().getColor() != null) {
            if (this.serverVersion.supportsRGB() && rgbClient) {
                String hexCode = iComponent.getModifier().getColor().getHexCode();
                char c = '\u00a7';
                sb.append(c).append("x").append(c).append(hexCode.charAt(0)).append(c).append(hexCode.charAt(1)).append(c).append(hexCode.charAt(2)).append(c).append(hexCode.charAt(3)).append(c).append(hexCode.charAt(4)).append(c).append(hexCode.charAt(5));
            } else {
                sb.append((Object)iComponent.getModifier().getColor().getLegacyColor());
            }
        }
        sb.append(iComponent.getModifier().getMagicCodes());
        sb.append(iComponent.getText());
        for (StructuredComponent extra : iComponent.getExtra()) {
            sb.append(this.toBukkitFormat(extra, rgbClient));
        }
        return sb.toString();
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public double[] getRecentTps() {
        return this.recentTps;
    }

    public boolean isPaperTps() {
        return this.paperTps;
    }

    public boolean isPaperMspt() {
        return this.paperMspt;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

