/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.platform;

import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import me.neznamy.tab.platforms.bukkit.features.PerWorldPlayerList;
import me.neznamy.tab.platforms.bukkit.platform.BukkitPlatform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.placeholders.types.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FoliaPlatform
extends BukkitPlatform {
    public FoliaPlatform(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void loadPlayers() {
        super.loadPlayers();
        this.logWarn(TabComponent.fromColoredText("Folia never updates MSPT and TPS values in the API, making %mspt% and %tps% return the default values (0 and 20)."));
        TAB.getInstance().getCpu().getProcessingThread().repeatTask(new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                String bukkitWorld = ((Player)player.getPlayer()).getWorld().getName();
                if (player.world.equals(bukkitWorld)) continue;
                TAB.getInstance().getFeatureManager().onWorldChange(player.getUniqueId(), bukkitWorld);
                PerWorldPlayerList pwp = (PerWorldPlayerList)TAB.getInstance().getFeatureManager().getFeature("PerWorldPlayerList");
                if (pwp == null) continue;
                this.runSync((Entity)player.getPlayer(), () -> pwp.onWorldChange(new PlayerChangedWorldEvent((Player)player.getPlayer(), ((Player)player.getPlayer()).getWorld())));
            }
        }, "Folia compatibility", "Refreshing world"), 100);
    }

    @Override
    public void registerSyncPlaceholder(@NotNull String identifier, int refresh) {
        PlayerPlaceholderImpl[] ppl;
        String syncedPlaceholder = "%" + identifier.substring(6);
        ppl = new PlayerPlaceholderImpl[]{TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(identifier, refresh, p -> {
            this.runSync((Entity)p.getPlayer(), () -> {
                long time = System.nanoTime();
                String output = this.isPlaceholderAPI() ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)syncedPlaceholder) : identifier;
                TAB.getInstance().getCPUManager().addPlaceholderTime(identifier, System.nanoTime() - time);
                TAB.getInstance().getCPUManager().runTask(() -> ppl[0].updateValue((me.neznamy.tab.api.TabPlayer)p, output));
            });
            return null;
        })};
    }

    @Override
    public void runSync(@NotNull Entity entity, @NotNull Runnable task) {
        Object entityScheduler = Entity.class.getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
        Consumer<Object> consumer = $ -> task.run();
        entityScheduler.getClass().getMethod("run", Plugin.class, Consumer.class, Runnable.class).invoke(entityScheduler, this.getPlugin(), consumer, null);
    }
}

