/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.scoreboard;

import java.util.concurrent.CountDownLatch;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static final int TEAM_COLOR_VERSION = 13;
    private static final int RENDER_TYPE_VERSION = 14;
    private static final int PREFIX_SUFFIX_LIMIT_MODERN = 64;
    private static final int TITLE_LIMIT_MODERN = 128;
    private static final boolean available = ReflectionUtils.methodExists(Bukkit.class, "getScoreboardManager", new Class[0]);
    private static DisplaySlot[] slots;
    private final int serverMinorVersion = BukkitReflection.getMinorVersion();
    protected Scoreboard scoreboard;

    public BukkitScoreboard(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.runSync(() -> {
            this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            player.getPlayer().setScoreboard(this.scoreboard);
        });
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        Objective obj = this.newObjective(objective.getName(), "dummy", objective.getTitle(), objective.getHealthDisplay());
        this.setObjectiveNumberFormat(obj, objective.getNumberFormat());
        obj.setDisplaySlot(slots[objective.getDisplaySlot().ordinal()]);
        objective.setPlatformObjective(obj);
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        ((Objective)objective.getPlatformObjective()).unregister();
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        Objective obj = (Objective)objective.getPlatformObjective();
        this.setDisplayName(obj, objective.getTitle());
        if (this.serverMinorVersion >= 14) {
            obj.setRenderType(RenderType.values()[objective.getHealthDisplay().ordinal()]);
        }
        this.setObjectiveNumberFormat(obj, objective.getNumberFormat());
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        Score s = this.serverMinorVersion >= 7 && ((BukkitTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_7_8.getNetworkId() ? ((Objective)score.getObjective().getPlatformObjective()).getScore(score.getHolder()) : ((Objective)score.getObjective().getPlatformObjective()).getScore(Bukkit.getOfflinePlayer((String)score.getHolder()));
        s.setScore(score.getValue());
        this.setScoreDisplayName(s, score.getDisplayName());
        this.setScoreNumberFormat(s, score.getNumberFormat());
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        if (this.serverMinorVersion >= 7 && ((BukkitTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_7_8.getNetworkId()) {
            this.scoreboard.resetScores(score.getHolder());
        } else {
            this.scoreboard.resetScores(Bukkit.getOfflinePlayer((String)score.getHolder()));
        }
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.scoreboard.registerNewTeam(name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        Team t = (Team)team.getPlatformTeam();
        this.setPrefix(t, team.getPrefix());
        this.setSuffix(t, team.getSuffix());
        if (this.serverMinorVersion >= 8) {
            t.setNameTagVisibility(NameTagVisibility.valueOf((String)team.getVisibility().name()));
        }
        if (this.serverMinorVersion >= 9) {
            t.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.values()[team.getCollision().ordinal()]);
        }
        if (this.serverMinorVersion >= 13) {
            t.setColor(ChatColor.valueOf((String)team.getColor().name()));
        }
        if (this.serverMinorVersion >= 7 && ((BukkitTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_7_8.getNetworkId()) {
            for (String player : team.getPlayers()) {
                t.addEntry(player);
            }
        } else {
            for (String player : team.getPlayers()) {
                t.addPlayer(Bukkit.getOfflinePlayer((String)player));
            }
        }
        t.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        t.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        team.setPlatformTeam(t);
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        ((Team)team.getPlatformTeam()).unregister();
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.checkPlayerScoreboard();
        Team t = (Team)team.getPlatformTeam();
        this.setPrefix(t, team.getPrefix());
        this.setSuffix(t, team.getSuffix());
        if (this.serverMinorVersion >= 8) {
            t.setNameTagVisibility(NameTagVisibility.valueOf((String)team.getVisibility().name()));
        }
        if (this.serverMinorVersion >= 9) {
            t.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.values()[team.getCollision().ordinal()]);
        }
        if (this.serverMinorVersion >= 13) {
            t.setColor(ChatColor.valueOf((String)team.getColor().name()));
        }
        t.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        t.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
    }

    public Objective newObjective(@NonNull String objectiveName, @NonNull String criteria, @NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay display) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (criteria == null) {
            throw new NullPointerException("criteria is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        if (this.serverMinorVersion >= 14) {
            return this.scoreboard.registerNewObjective(objectiveName, criteria, this.transform(title, 128, 32), RenderType.values()[display.ordinal()]);
        }
        Objective obj = this.scoreboard.registerNewObjective(objectiveName, display == Scoreboard.HealthDisplay.HEARTS ? "health" : "dummy");
        this.setDisplayName(obj, title);
        return obj;
    }

    public void setDisplayName(@NonNull Objective objective, @NonNull TabComponent displayName) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        objective.setDisplayName(this.transform(displayName, 128, 32));
    }

    public void setPrefix(@NonNull Team team, @NonNull TabComponent prefix) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        team.setPrefix(this.transform(prefix, 64, 16));
    }

    public void setSuffix(@NonNull Team team, @NonNull TabComponent suffix) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        team.setSuffix(this.transform(suffix, 64, 16));
    }

    @NotNull
    private String transform(@NonNull TabComponent text, int maxLengthModern, int maxLengthLegacy) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String transformed = ((BukkitTabPlayer)this.player).getPlatform().toBukkitFormat(text, ((BukkitTabPlayer)this.player).getVersion().supportsRGB());
        if (((BukkitTabPlayer)this.player).getPlatform().getServerVersion().supportsRGB() && maxLengthModern < 128) {
            while (ChatColor.stripColor((String)transformed).length() > maxLengthModern) {
                transformed = transformed.substring(0, transformed.length() - 1);
            }
        } else if (this.serverMinorVersion >= 13) {
            if (transformed.length() > maxLengthModern) {
                transformed = transformed.substring(0, maxLengthModern);
            }
        } else if (transformed.length() > maxLengthLegacy) {
            transformed = transformed.substring(0, maxLengthLegacy);
        }
        return transformed;
    }

    public void setScoreDisplayName(@NotNull Score s, @Nullable TabComponent displayName) {
    }

    public void setScoreNumberFormat(@NotNull Score s, @Nullable TabComponent numberFormat) {
    }

    public void setObjectiveNumberFormat(@NotNull Objective o, @Nullable TabComponent numberFormat) {
    }

    private void checkPlayerScoreboard() {
        if (((BukkitTabPlayer)this.player).getPlayer().getScoreboard() != this.scoreboard) {
            this.runSync(() -> ((BukkitTabPlayer)this.player).getPlayer().setScoreboard(this.scoreboard));
        }
    }

    private void runSync(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            CountDownLatch c = new CountDownLatch(1);
            ((BukkitTabPlayer)this.player).getPlatform().runSync((Entity)((BukkitTabPlayer)this.player).getPlayer(), () -> {
                task.run();
                c.countDown();
            });
            c.await();
        }
    }

    public static boolean isAvailable() {
        return available;
    }

    static {
        if (available) {
            slots = new DisplaySlot[]{DisplaySlot.PLAYER_LIST, DisplaySlot.SIDEBAR, DisplaySlot.BELOW_NAME};
        }
    }
}

