/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.scoreboard;

import java.lang.reflect.Method;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.scoreboard.BukkitScoreboard;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperScoreboard
extends BukkitScoreboard {
    private static final boolean available = ReflectionUtils.classExists("net.kyori.adventure.text.Component") && ReflectionUtils.methodExists(Team.class, "prefix", Component.class);
    private static final boolean numberFormatAPI = ReflectionUtils.classExists("io.papermc.paper.scoreboard.numbers.NumberFormat");

    public PaperScoreboard(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public Objective newObjective(@NonNull String objectiveName, @NonNull String criteria, @NonNull TabComponent title, @NonNull Scoreboard.HealthDisplay display) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (criteria == null) {
            throw new NullPointerException("criteria is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (display == null) {
            throw new NullPointerException("display is marked non-null but is null");
        }
        return this.scoreboard.registerNewObjective(objectiveName, criteria, title.toAdventure(((BukkitTabPlayer)this.player).getVersion()), RenderType.values()[display.ordinal()]);
    }

    @Override
    public void setDisplayName(@NonNull Objective objective, @NonNull TabComponent displayName) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        objective.displayName(displayName.toAdventure(((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void setPrefix(@NonNull Team team, @NonNull TabComponent prefix) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        team.prefix(prefix.toAdventure(((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void setSuffix(@NonNull Team team, @NonNull TabComponent suffix) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        team.suffix(suffix.toAdventure(((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void setScoreDisplayName(@NotNull Score s, @Nullable TabComponent displayName) {
        if (numberFormatAPI) {
            Component component = displayName == null ? null : displayName.toAdventure(((BukkitTabPlayer)this.player).getVersion());
            Method m = s.getClass().getMethod("customName", Component.class);
            m.setAccessible(true);
            m.invoke((Object)s, component);
        }
    }

    @Override
    public void setScoreNumberFormat(@NotNull Score s, @Nullable TabComponent numberFormat) {
        if (numberFormatAPI) {
            Class<?> numberFormatClass = Class.forName("io.papermc.paper.scoreboard.numbers.NumberFormat");
            Method m = s.getClass().getMethod("numberFormat", numberFormatClass);
            m.setAccessible(true);
            m.invoke((Object)s, this.numberFormat(numberFormat));
        }
    }

    @Override
    public void setObjectiveNumberFormat(@NotNull Objective o, @Nullable TabComponent numberFormat) {
        if (numberFormatAPI) {
            Class<?> numberFormatClass = Class.forName("io.papermc.paper.scoreboard.numbers.NumberFormat");
            Method m = o.getClass().getMethod("numberFormat", numberFormatClass);
            m.setAccessible(true);
            m.invoke((Object)o, this.numberFormat(numberFormat));
        }
    }

    @Nullable
    private Object numberFormat(@Nullable TabComponent numberFormat) {
        if (numberFormat == null) {
            return null;
        }
        return Class.forName("io.papermc.paper.scoreboard.numbers.NumberFormat").getMethod("fixed", ComponentLike.class).invoke(null, numberFormat.toAdventure(((BukkitTabPlayer)this.player).getVersion()));
    }

    public static boolean isAvailable() {
        return available;
    }
}

