/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.scoreboard;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumSet;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.scoreboard.BukkitScoreboard;
import me.neznamy.tab.platforms.bukkit.scoreboard.PaperScoreboard;
import me.neznamy.tab.platforms.bukkit.scoreboard.packet.PacketScoreboard;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.impl.DummyScoreboard;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class ScoreboardLoader {
    private static final EnumSet<ProtocolVersion> paperNativeVersions = EnumSet.of(ProtocolVersion.V1_20_5, new ProtocolVersion[]{ProtocolVersion.V1_20_6, ProtocolVersion.V1_21, ProtocolVersion.V1_21_1, ProtocolVersion.V1_21_2, ProtocolVersion.V1_21_3});
    @NotNull
    private static FunctionWithException<BukkitTabPlayer, Scoreboard> instance = DummyScoreboard::new;

    public static void findInstance(@NotNull ProtocolVersion serverVersion) {
        if (ReflectionUtils.classExists("org.bukkit.craftbukkit.CraftServer") && paperNativeVersions.contains((Object)serverVersion)) {
            Constructor<?> constructor = Class.forName("me.neznamy.tab.platforms.paper.PaperPacketScoreboard").getConstructor(BukkitTabPlayer.class);
            instance = player -> (Scoreboard)constructor.newInstance(player);
        } else if (PacketScoreboard.isAvailable()) {
            instance = PacketScoreboard::new;
        } else if (PaperScoreboard.isAvailable()) {
            instance = PaperScoreboard::new;
            BukkitUtils.compatibilityError(PacketScoreboard.getException(), "Scoreboards", "Paper API", "Compatibility with other plugins being reduced");
        } else if (BukkitScoreboard.isAvailable()) {
            instance = BukkitScoreboard::new;
            ArrayList missingFeatures = Lists.newArrayList((Object[])new String[]{"Compatibility with other plugins being reduced", "Features receiving new artificial character limits"});
            if (BukkitReflection.is1_20_3Plus()) {
                missingFeatures.add("1.20.3+ visuals not working due to lack of API");
            }
            BukkitUtils.compatibilityError(PacketScoreboard.getException(), "Scoreboards", "Bukkit API", missingFeatures.toArray(new String[0]));
        } else {
            BukkitUtils.compatibilityError(PacketScoreboard.getException(), "Scoreboards", null, "Scoreboard feature will not work", "Belowname feature will not work", "Player objective feature will not work", "Scoreboard teams feature will not work (nametags & sorting)");
        }
    }

    @NotNull
    public static FunctionWithException<BukkitTabPlayer, Scoreboard> getInstance() {
        return instance;
    }

    public static void setInstance(@NotNull FunctionWithException<BukkitTabPlayer, Scoreboard> instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        ScoreboardLoader.instance = instance;
    }
}

