/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.scoreboard.packet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.nms.PacketSender;
import me.neznamy.tab.platforms.bukkit.nms.converter.ComponentConverter;
import me.neznamy.tab.platforms.bukkit.scoreboard.packet.DisplayPacketData;
import me.neznamy.tab.platforms.bukkit.scoreboard.packet.ScorePacketData;
import me.neznamy.tab.platforms.bukkit.scoreboard.packet.TeamPacketData;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static boolean available;
    private static Exception exception;
    static Class<?> Component;
    static Class<?> Scoreboard;
    static Class<?> ScoreboardObjective;
    static Object emptyScoreboard;
    static Class<?> NumberFormat;
    private static Constructor<?> newFixedFormat;
    private static Class<?> ObjectivePacketClass;
    private static Constructor<?> newObjectivePacket;
    private static Field Objective_OBJECTIVE_NAME;
    private static Field Objective_METHOD;
    private static Field Objective_RENDER_TYPE;
    static Constructor<?> newScoreboardObjective;
    private static Method ScoreboardObjective_setDisplayName;
    private static Enum<?>[] healthDisplays;
    static Object IScoreboardCriteria_dummy;
    private static ScorePacketData scorePacketData;
    private static TeamPacketData teamPacketData;
    private static DisplayPacketData displayPacketData;
    private static PacketSender packetSender;

    public PacketScoreboard(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, this.newObjectivePacket(0, objective));
        packetSender.sendPacket((BukkitTabPlayer)this.player, displayPacketData.setDisplaySlot(objective.getDisplaySlot().ordinal(), this.newObjective(objective)));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, this.newObjectivePacket(1, objective));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, this.newObjectivePacket(2, objective));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, scorePacketData.setScore(score.getObjective().getName(), score.getHolder(), score.getValue(), score.getDisplayName() == null ? null : score.getDisplayName().convert(((BukkitTabPlayer)this.player).getVersion()), score.getNumberFormat() == null ? null : PacketScoreboard.toFixedFormat(score.getNumberFormat())));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, scorePacketData.removeScore(score.getObjective().getName(), score.getHolder()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return teamPacketData.createTeam(name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, teamPacketData.registerTeam(team, ((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, teamPacketData.unregisterTeam(team));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        packetSender.sendPacket((BukkitTabPlayer)this.player, teamPacketData.updateTeam(team, ((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.isAntiOverrideScoreboard()) {
            displayPacketData.onPacketSend(this.player, packet);
            if (ObjectivePacketClass.isInstance(packet)) {
                TAB.getInstance().getFeatureManager().onObjective(this.player, Objective_METHOD.getInt(packet), (String)Objective_OBJECTIVE_NAME.get(packet));
            }
        }
        if (this.isAntiOverrideTeams()) {
            teamPacketData.onPacketSend(this.player, packet);
        }
    }

    private Object newObjectivePacket(int action, @NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Object packet = newObjectivePacket.newInstance(this.newObjective(objective), action);
        if (BukkitReflection.getMinorVersion() >= 8 && BukkitReflection.getMinorVersion() < 13) {
            Objective_RENDER_TYPE.set(packet, healthDisplays[objective.getHealthDisplay().ordinal()]);
        }
        return packet;
    }

    private Object newObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (BukkitReflection.is1_20_3Plus()) {
            return newScoreboardObjective.newInstance(emptyScoreboard, objective.getName(), null, objective.getTitle().convert(((BukkitTabPlayer)this.player).getVersion()), healthDisplays[objective.getHealthDisplay().ordinal()], false, objective.getNumberFormat() == null ? null : PacketScoreboard.toFixedFormat(objective.getNumberFormat()));
        }
        if (BukkitReflection.getMinorVersion() >= 13) {
            return newScoreboardObjective.newInstance(emptyScoreboard, objective.getName(), null, objective.getTitle().convert(((BukkitTabPlayer)this.player).getVersion()), healthDisplays[objective.getHealthDisplay().ordinal()]);
        }
        Object nmsObjective = newScoreboardObjective.newInstance(emptyScoreboard, objective.getName(), IScoreboardCriteria_dummy);
        String cutTitle = ((BukkitTabPlayer)this.player).getVersion().getMinorVersion() >= 13 ? objective.getTitle().toLegacyText() : PacketScoreboard.cutTo(objective.getTitle().toLegacyText(), 32);
        ScoreboardObjective_setDisplayName.invoke(nmsObjective, cutTitle);
        return nmsObjective;
    }

    @Nullable
    private static Object toFixedFormat(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (newFixedFormat == null) {
            return null;
        }
        return component.toFixedFormat(nmsComponent -> newFixedFormat.newInstance(nmsComponent));
    }

    public static boolean isAvailable() {
        return available;
    }

    public static Exception getException() {
        return exception;
    }

    public static TeamPacketData getTeamPacketData() {
        return teamPacketData;
    }

    public static DisplayPacketData getDisplayPacketData() {
        return displayPacketData;
    }

    static {
        try {
            int minorVersion = BukkitReflection.getMinorVersion();
            Scoreboard = BukkitReflection.getClass("world.scores.Scoreboard", "Scoreboard");
            ScoreboardObjective = BukkitReflection.getClass("world.scores.Objective", "world.scores.ScoreboardObjective", "ScoreboardObjective");
            Class<?> IScoreboardCriteria = BukkitReflection.getClass("world.scores.criteria.ObjectiveCriteria", "world.scores.criteria.IScoreboardCriteria", "IScoreboardCriteria", "IObjective");
            ObjectivePacketClass = BukkitReflection.getClass("network.protocol.game.ClientboundSetObjectivePacket", "network.protocol.game.PacketPlayOutScoreboardObjective", "PacketPlayOutScoreboardObjective", "Packet206SetScoreboardObjective");
            emptyScoreboard = Scoreboard.getConstructor(new Class[0]).newInstance(new Object[0]);
            Objective_OBJECTIVE_NAME = ReflectionUtils.getFields(ObjectivePacketClass, String.class).get(0);
            List<Field> list = ReflectionUtils.getFields(ObjectivePacketClass, Integer.TYPE);
            Objective_METHOD = list.get(list.size() - 1);
            newObjectivePacket = ObjectivePacketClass.getConstructor(ScoreboardObjective, Integer.TYPE);
            IScoreboardCriteria_dummy = ReflectionUtils.getFields(IScoreboardCriteria, IScoreboardCriteria).get(0).get(null);
            newScoreboardObjective = ReflectionUtils.getOnlyConstructor(ScoreboardObjective);
            if (minorVersion >= 7) {
                Component = BukkitReflection.getClass("network.chat.Component", "network.chat.IChatBaseComponent", "IChatBaseComponent");
                if (ComponentConverter.INSTANCE == null) {
                    throw new IllegalStateException("Component converter is not available");
                }
            }
            if (minorVersion >= 8) {
                Class<?> EnumScoreboardHealthDisplay = BukkitReflection.getClass("world.scores.criteria.ObjectiveCriteria$RenderType", "world.scores.criteria.IScoreboardCriteria$EnumScoreboardHealthDisplay", "IScoreboardCriteria$EnumScoreboardHealthDisplay", "EnumScoreboardHealthDisplay");
                healthDisplays = (Enum[])EnumScoreboardHealthDisplay.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                if (minorVersion < 13) {
                    Objective_RENDER_TYPE = ReflectionUtils.getOnlyField(ObjectivePacketClass, EnumScoreboardHealthDisplay);
                }
            }
            if (minorVersion < 13) {
                ScoreboardObjective_setDisplayName = ReflectionUtils.getOnlyMethod(ScoreboardObjective, Void.TYPE, String.class);
            }
            if (BukkitReflection.is1_20_3Plus()) {
                NumberFormat = BukkitReflection.getClass("network.chat.numbers.NumberFormat");
                newFixedFormat = BukkitReflection.getClass("network.chat.numbers.FixedFormat").getConstructor(Component);
            }
            scorePacketData = new ScorePacketData();
            teamPacketData = new TeamPacketData();
            displayPacketData = new DisplayPacketData();
            packetSender = new PacketSender();
            available = true;
        }
        catch (Exception e) {
            exception = e;
        }
    }
}

