/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.scoreboard.packet;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.BiConsumerWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class TeamPacketData {
    private final boolean MODERN_TEAM_DATA_VERSION = BukkitReflection.getMinorVersion() >= 13;
    private final boolean STATIC_CONSTRUCTOR_VERSION = BukkitReflection.getMinorVersion() >= 17;
    private final Object emptyScoreboard;
    private final Class<?> TeamPacketClass;
    private Constructor<?> newTeamPacket;
    private final Constructor<?> newScoreboardTeam;
    private Method TeamPacketConstructor_of;
    private Method TeamPacketConstructor_ofBoolean;
    private final Field TeamPacket_NAME;
    private final Field TeamPacket_ACTION;
    private final Field TeamPacket_PLAYERS;
    private final Method ScoreboardTeam_setPrefix;
    private final Method ScoreboardTeam_setSuffix;
    private Method ScoreboardTeam_setColor;
    private final Method ScoreboardTeam_setAllowFriendlyFire;
    private final Method ScoreboardTeam_setCanSeeFriendlyInvisibles;
    private final Enum<?>[] chatFormats;
    private BiConsumerWithException<Object, Scoreboard.NameVisibility> setVisibility = (team, visibility) -> {};
    private BiConsumerWithException<Object, Scoreboard.CollisionRule> setCollision = (team, collision) -> {};

    public TeamPacketData() throws ReflectiveOperationException {
        int minorVersion = BukkitReflection.getMinorVersion();
        Class<?> Scoreboard2 = BukkitReflection.getClass("world.scores.Scoreboard", "Scoreboard");
        Class<?> scoreboardTeam = BukkitReflection.getClass("world.scores.PlayerTeam", "world.scores.ScoreboardTeam", "ScoreboardTeam");
        Class<?> enumChatFormatClass = BukkitReflection.getClass("ChatFormatting", "EnumChatFormat");
        this.TeamPacketClass = BukkitReflection.getClass("network.protocol.game.ClientboundSetPlayerTeamPacket", "network.protocol.game.PacketPlayOutScoreboardTeam", "PacketPlayOutScoreboardTeam", "Packet209SetScoreboardTeam");
        this.emptyScoreboard = Scoreboard2.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.newScoreboardTeam = scoreboardTeam.getConstructor(Scoreboard2, String.class);
        this.TeamPacket_NAME = ReflectionUtils.getFields(this.TeamPacketClass, String.class).get(0);
        List<Field> intFields = ReflectionUtils.getInstanceFields(this.TeamPacketClass, Integer.TYPE);
        this.TeamPacket_ACTION = minorVersion >= 8 && minorVersion <= 12 ? intFields.get(1) : intFields.get(0);
        this.TeamPacket_PLAYERS = ReflectionUtils.getOnlyField(this.TeamPacketClass, Collection.class);
        this.chatFormats = (Enum[])enumChatFormatClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        this.ScoreboardTeam_setAllowFriendlyFire = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"func_96660_a", "setAllowFriendlyFire", "a", "m_83355_"}, Boolean.TYPE);
        this.ScoreboardTeam_setCanSeeFriendlyInvisibles = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"func_98300_b", "setCanSeeFriendlyInvisibles", "b", "m_83362_", "setSeeFriendlyInvisibles"}, Boolean.TYPE);
        if (minorVersion >= 8) {
            this.loadVisibility(scoreboardTeam);
        }
        if (minorVersion >= 9) {
            this.loadCollision(scoreboardTeam);
        }
        if (this.MODERN_TEAM_DATA_VERSION) {
            Class<?> Component2 = BukkitReflection.getClass("network.chat.Component", "network.chat.IChatBaseComponent", "IChatBaseComponent");
            this.ScoreboardTeam_setColor = ReflectionUtils.getOnlyMethod(scoreboardTeam, Void.TYPE, enumChatFormatClass);
            this.ScoreboardTeam_setPrefix = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"setPrefix", "b", "m_83360_", "setPlayerPrefix"}, Component2);
            this.ScoreboardTeam_setSuffix = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"setSuffix", "c", "m_83365_", "setPlayerSuffix"}, Component2);
        } else {
            this.ScoreboardTeam_setPrefix = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"func_96666_b", "setPrefix", "b"}, String.class);
            this.ScoreboardTeam_setSuffix = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"func_96662_c", "setSuffix", "c"}, String.class);
        }
        if (this.STATIC_CONSTRUCTOR_VERSION) {
            this.TeamPacketConstructor_of = ReflectionUtils.getOnlyMethod(this.TeamPacketClass, this.TeamPacketClass, scoreboardTeam);
            this.TeamPacketConstructor_ofBoolean = ReflectionUtils.getOnlyMethod(this.TeamPacketClass, this.TeamPacketClass, scoreboardTeam, Boolean.TYPE);
        } else {
            this.newTeamPacket = this.TeamPacketClass.getConstructor(scoreboardTeam, Integer.TYPE);
        }
    }

    private void loadVisibility(@NonNull Class<?> scoreboardTeam) {
        if (scoreboardTeam == null) {
            throw new NullPointerException("scoreboardTeam is marked non-null but is null");
        }
        Class<?> enumNameTagVisibility = BukkitReflection.getClass("world.scores.Team$Visibility", "world.scores.ScoreboardTeamBase$EnumNameTagVisibility", "ScoreboardTeamBase$EnumNameTagVisibility", "EnumNameTagVisibility");
        Enum[] nameVisibilities = (Enum[])enumNameTagVisibility.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        Method setNameTagVisibility = ReflectionUtils.getMethod(scoreboardTeam, new String[]{"setNameTagVisibility", "a", "m_83346_"}, enumNameTagVisibility);
        this.setVisibility = (team, visibility) -> setNameTagVisibility.invoke(team, nameVisibilities[visibility.ordinal()]);
    }

    private void loadCollision(@NonNull Class<?> scoreboardTeam) {
        if (scoreboardTeam == null) {
            throw new NullPointerException("scoreboardTeam is marked non-null but is null");
        }
        Class<?> enumTeamPush = BukkitReflection.getClass("world.scores.Team$CollisionRule", "world.scores.ScoreboardTeamBase$EnumTeamPush", "ScoreboardTeamBase$EnumTeamPush");
        Enum[] collisionRules = (Enum[])enumTeamPush.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        Method setCollisionRule = ReflectionUtils.getOnlyMethod(scoreboardTeam, Void.TYPE, enumTeamPush);
        this.setCollision = (team, collision) -> setCollisionRule.invoke(team, collisionRules[collision.ordinal()]);
    }

    public Object registerTeam(@NonNull SafeScoreboard.Team team, @NotNull ProtocolVersion clientVersion) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamData(team, clientVersion);
        Object packet = this.STATIC_CONSTRUCTOR_VERSION ? this.TeamPacketConstructor_ofBoolean.invoke(null, team.getPlatformTeam(), true) : this.newTeamPacket.newInstance(team.getPlatformTeam(), 0);
        this.TeamPacket_PLAYERS.set(packet, team.getPlayers());
        return packet;
    }

    public Object unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        if (this.STATIC_CONSTRUCTOR_VERSION) {
            return this.TeamPacketConstructor_of.invoke(null, team.getPlatformTeam());
        }
        return this.newTeamPacket.newInstance(team.getPlatformTeam(), 1);
    }

    public Object updateTeam(@NonNull SafeScoreboard.Team team, @NotNull ProtocolVersion clientVersion) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamData(team, clientVersion);
        if (this.STATIC_CONSTRUCTOR_VERSION) {
            return this.TeamPacketConstructor_ofBoolean.invoke(null, team.getPlatformTeam(), false);
        }
        return this.newTeamPacket.newInstance(team.getPlatformTeam(), 2);
    }

    private void updateTeamData(@NonNull SafeScoreboard.Team team, @NotNull ProtocolVersion clientVersion) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        Object nmsTeam = team.getPlatformTeam();
        this.ScoreboardTeam_setAllowFriendlyFire.invoke(nmsTeam, (team.getOptions() & 1) > 0);
        this.ScoreboardTeam_setCanSeeFriendlyInvisibles.invoke(nmsTeam, (team.getOptions() & 2) > 0);
        if (this.MODERN_TEAM_DATA_VERSION) {
            this.ScoreboardTeam_setPrefix.invoke(nmsTeam, team.getPrefix().convert(clientVersion));
            this.ScoreboardTeam_setSuffix.invoke(nmsTeam, team.getSuffix().convert(clientVersion));
            this.ScoreboardTeam_setColor.invoke(nmsTeam, this.chatFormats[team.getColor().ordinal()]);
        } else {
            String prefix = team.getPrefix().toLegacyText();
            String suffix = team.getSuffix().toLegacyText();
            if (clientVersion.getMinorVersion() < 13) {
                prefix = SafeScoreboard.cutTo(prefix, 16);
                suffix = SafeScoreboard.cutTo(suffix, 16);
            }
            this.ScoreboardTeam_setPrefix.invoke(nmsTeam, prefix);
            this.ScoreboardTeam_setSuffix.invoke(nmsTeam, suffix);
        }
        this.setVisibility.accept(nmsTeam, team.getVisibility());
        this.setCollision.accept(nmsTeam, team.getCollision());
    }

    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.newScoreboardTeam.newInstance(this.emptyScoreboard, name);
    }

    public void onPacketSend(@NonNull TabPlayer player, @NonNull Object packet) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (!this.TeamPacketClass.isInstance(packet)) {
            return;
        }
        int action = this.TeamPacket_ACTION.getInt(packet);
        if (action == 2) {
            return;
        }
        List<String> players = (List<String>)this.TeamPacket_PLAYERS.get(packet);
        if (players == null) {
            players = Collections.emptyList();
        }
        this.TeamPacket_PLAYERS.set(packet, ((SafeScoreboard)player.getScoreboard()).onTeamPacket(action, (String)this.TeamPacket_NAME.get(packet), players));
    }

    public Class<?> getTeamPacketClass() {
        return this.TeamPacketClass;
    }
}

