/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.tablist;

import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.tablist.TabListBase;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BukkitTabList
extends TabListBase<String> {
    public BukkitTabList(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable String displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        Player p = Bukkit.getPlayer((UUID)entry);
        if (p == null) {
            return;
        }
        p.setPlayerListName(displayName);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable String displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @Override
    public String toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return ((BukkitTabPlayer)this.player).getPlatform().toBukkitFormat(component, true);
    }
}

