/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.tablist;

import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.header.HeaderFooter;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.tablist.BukkitTabList;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList1193;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList17;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList18;
import me.neznamy.tab.platforms.bukkit.tablist.SkinData;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabListBase<C>
extends TrackedTabList<BukkitTabPlayer, C> {
    private static final EnumSet<ProtocolVersion> paperNativeVersions = EnumSet.of(ProtocolVersion.V1_21_2, ProtocolVersion.V1_21_3);
    private static FunctionWithException<BukkitTabPlayer, TabListBase<?>> instance;
    @Nullable
    protected static SkinData skinData;

    protected TabListBase(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    public static void findInstance(@NotNull ProtocolVersion serverVersion) {
        try {
            if (ReflectionUtils.classExists("org.bukkit.craftbukkit.CraftServer") && paperNativeVersions.contains((Object)serverVersion)) {
                Constructor<?> constructor = Class.forName("me.neznamy.tab.platforms.paper.PaperPacketTabList").getConstructor(BukkitTabPlayer.class);
                instance = player -> (TabListBase)constructor.newInstance(player);
            } else if (ReflectionUtils.classExists("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket")) {
                PacketTabList1193.loadNew();
                instance = PacketTabList1193::new;
            } else if (BukkitReflection.getMinorVersion() >= 8) {
                PacketTabList18.load();
                instance = PacketTabList18::new;
            } else {
                PacketTabList17.load();
                instance = PacketTabList17::new;
            }
        }
        catch (Exception e) {
            BukkitUtils.compatibilityError(e, "tablist entry management", "Bukkit API", "Layout feature will not work", "Prevent-spectator-effect feature will not work", "Ping spoof feature will not work", "Tablist formatting missing anti-override", "Tablist formatting not supporting relational placeholders");
            instance = BukkitTabList::new;
        }
    }

    @Override
    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        if (HeaderFooter.getInstance() != null) {
            HeaderFooter.getInstance().set((BukkitTabPlayer)this.player, header, footer);
        }
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return true;
    }

    @Nullable
    public TabList.Skin getSkin() {
        if (skinData == null) {
            return null;
        }
        return skinData.getSkin((BukkitTabPlayer)this.player);
    }

    public static FunctionWithException<BukkitTabPlayer, TabListBase<?>> getInstance() {
        return instance;
    }

    public static void setInstance(FunctionWithException<BukkitTabPlayer, TabListBase<?>> instance) {
        TabListBase.instance = instance;
    }
}

