/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.NumberFormat;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ScoreboardScoreReset;
import net.md_5.bungee.protocol.packet.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeeScoreboard
extends SafeScoreboard<BungeeTabPlayer> {
    private final int TEAM_REWORK_VERSION = 13;

    public BungeeScoreboard(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardObjective(objective.getName(), this.either(objective.getTitle(), 32), ScoreboardObjective.HealthDisplay.values()[objective.getHealthDisplay().ordinal()], 0, this.numberFormat(objective.getNumberFormat())));
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardDisplay(objective.getDisplaySlot().ordinal(), objective.getName()));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardObjective(objective.getName(), this.either(objective.getTitle(), 32), null, 1, null));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardObjective(objective.getName(), this.either(objective.getTitle(), 32), ScoreboardObjective.HealthDisplay.values()[objective.getHealthDisplay().ordinal()], 2, this.numberFormat(objective.getNumberFormat())));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardScore(score.getHolder(), 0, score.getObjective().getName(), score.getValue(), score.getDisplayName() == null ? null : (BaseComponent)score.getDisplayName().convert(((BungeeTabPlayer)this.player).getVersion()), this.numberFormat(score.getNumberFormat())));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        if (((BungeeTabPlayer)this.player).getVersion().getNetworkId() >= ProtocolVersion.V1_20_3.getNetworkId()) {
            ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardScoreReset(score.getHolder(), score.getObjective().getName()));
        } else {
            ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new ScoreboardScore(score.getHolder(), 1, score.getObjective().getName(), 0, null, null));
        }
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new Object();
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new Team(team.getName(), 0, this.either(new SimpleComponent(team.getName()), 16), this.either(team.getPrefix(), 16), this.either(team.getSuffix(), 16), team.getVisibility().toString(), team.getCollision().toString(), ((BungeeTabPlayer)this.player).getVersion().getMinorVersion() >= 13 ? team.getColor().ordinal() : 0, (byte)team.getOptions(), team.getPlayers().toArray(new String[0])));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new Team(team.getName()));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new Team(team.getName(), 2, this.either(new SimpleComponent(team.getName()), 16), this.either(team.getPrefix(), 16), this.either(team.getSuffix(), 16), team.getVisibility().toString(), team.getCollision().toString(), ((BungeeTabPlayer)this.player).getVersion().getMinorVersion() >= 13 ? team.getColor().ordinal() : 0, (byte)team.getOptions(), null));
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.isAntiOverrideScoreboard()) {
            if (packet instanceof ScoreboardDisplay) {
                ScoreboardDisplay display = (ScoreboardDisplay)packet;
                TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, display.getPosition(), display.getName());
            }
            if (packet instanceof ScoreboardObjective) {
                ScoreboardObjective objective = (ScoreboardObjective)packet;
                TAB.getInstance().getFeatureManager().onObjective(this.player, objective.getAction(), objective.getName());
            }
        }
        if (this.isAntiOverrideTeams() && packet instanceof Team) {
            Team team = (Team)packet;
            if (team.getMode() == 2) {
                return;
            }
            ArrayList players = team.getPlayers() == null ? Collections.emptyList() : Lists.newArrayList((Object[])team.getPlayers());
            team.setPlayers(this.onTeamPacket(team.getMode(), team.getName(), players).toArray(new String[0]));
        }
    }

    private Either<String, BaseComponent> either(@NonNull TabComponent text, int legacyLimit) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (((BungeeTabPlayer)this.player).getVersion().getMinorVersion() >= 13) {
            return Either.right((Object)((BaseComponent)text.convert(((BungeeTabPlayer)this.player).getVersion())));
        }
        return Either.left((Object)BungeeScoreboard.cutTo(text.toLegacyText(), legacyLimit));
    }

    @Nullable
    private NumberFormat numberFormat(@Nullable TabComponent component) {
        return component == null ? null : component.toFixedFormat(baseComponent -> new NumberFormat(NumberFormat.Type.FIXED, baseComponent));
    }
}

