/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import me.neznamy.tab.platforms.bungeecord.BungeePlatform;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeeTabPlayer
extends ProxyTabPlayer {
    public BungeeTabPlayer(@NotNull BungeePlatform platform, @NotNull ProxiedPlayer p) {
        super(platform, p, p.getUniqueId(), p.getName(), p.getServer() != null ? p.getServer().getInfo().getName() : "-", p.getPendingConnection().getVersion());
    }

    @Override
    public boolean hasPermission0(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().getPing();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage((BaseComponent)message.convert(this.getVersion()));
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        LoginResult loginResult = ((InitialHandler)this.getPlayer().getPendingConnection()).getLoginProfile();
        if (loginResult == null) {
            return null;
        }
        Property[] properties = loginResult.getProperties();
        if (properties == null) {
            return null;
        }
        for (Property property : properties) {
            if (!property.getName().equals("textures")) continue;
            return new TabList.Skin(property.getValue(), property.getSignature());
        }
        return null;
    }

    @NotNull
    public ProxiedPlayer getPlayer() {
        return (ProxiedPlayer)this.player;
    }

    @Override
    public BungeePlatform getPlatform() {
        return (BungeePlatform)this.platform;
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        this.getPlayer().getServer().sendData("tab:bridge-6", message);
    }

    public void sendPacket(@NotNull DefinedPacket packet) {
        ((UserConnection)this.getPlayer()).sendPacketQueued(packet);
    }
}

