/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.EnumSet;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.platform.TabList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import org.jetbrains.annotations.Nullable;

public class BungeeTabList1193
extends BungeeTabList {
    private static final EnumSet<PlayerListItemUpdate.Action> updateDisplayName = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME);
    private static final EnumSet<PlayerListItemUpdate.Action> updateLatency = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_LATENCY);
    private static final EnumSet<PlayerListItemUpdate.Action> updateGameMode = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_GAMEMODE);
    private static final EnumSet<PlayerListItemUpdate.Action> updateListed = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_LISTED);
    private static final EnumSet<PlayerListItemUpdate.Action> updateListOrder = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_LIST_ORDER);
    private static final EnumSet<PlayerListItemUpdate.Action> updateHat = EnumSet.of(PlayerListItemUpdate.Action.UPDATE_HAT);
    private static final EnumSet<PlayerListItemUpdate.Action> addPlayer_legacy = EnumSet.of(PlayerListItemUpdate.Action.ADD_PLAYER, PlayerListItemUpdate.Action.UPDATE_GAMEMODE, PlayerListItemUpdate.Action.UPDATE_LISTED, PlayerListItemUpdate.Action.UPDATE_LATENCY, PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME);
    private static final EnumSet<PlayerListItemUpdate.Action> addPlayer_1_21_2 = EnumSet.of(PlayerListItemUpdate.Action.ADD_PLAYER, new PlayerListItemUpdate.Action[]{PlayerListItemUpdate.Action.UPDATE_GAMEMODE, PlayerListItemUpdate.Action.UPDATE_LISTED, PlayerListItemUpdate.Action.UPDATE_LATENCY, PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME, PlayerListItemUpdate.Action.UPDATE_LIST_ORDER});
    private static final EnumSet<PlayerListItemUpdate.Action> addPlayer_1_21_4 = EnumSet.of(PlayerListItemUpdate.Action.ADD_PLAYER, new PlayerListItemUpdate.Action[]{PlayerListItemUpdate.Action.UPDATE_GAMEMODE, PlayerListItemUpdate.Action.UPDATE_LISTED, PlayerListItemUpdate.Action.UPDATE_LATENCY, PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME, PlayerListItemUpdate.Action.UPDATE_LIST_ORDER, PlayerListItemUpdate.Action.UPDATE_HAT});

    public BungeeTabList1193(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.removeUuid(entry);
        PlayerListItemRemove remove = new PlayerListItemRemove();
        remove.setUuids(new UUID[]{entry});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)remove);
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable BaseComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setDisplayName(displayName);
        this.sendPacket(updateDisplayName, item);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setPing(Integer.valueOf(latency));
        this.sendPacket(updateLatency, item);
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setGamemode(Integer.valueOf(gameMode));
        this.sendPacket(updateGameMode, item);
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setListed(Boolean.valueOf(listed));
        this.sendPacket(updateListed, item);
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (((BungeeTabPlayer)this.player).getVersion().getNetworkId() < ProtocolVersion.V1_21_2.getNetworkId()) {
            return;
        }
        PlayerListItem.Item item = this.item(entry);
        item.setListOrder(Integer.valueOf(listOrder));
        this.sendPacket(updateListOrder, item);
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (((BungeeTabPlayer)this.player).getVersion().getNetworkId() < ProtocolVersion.V1_21_4.getNetworkId()) {
            return;
        }
        PlayerListItem.Item item = this.item(entry);
        item.setShowHat(Boolean.valueOf(showHat));
        this.sendPacket(updateHat, item);
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable BaseComponent displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.addUuid(id);
        EnumSet<PlayerListItemUpdate.Action> actions = ((BungeeTabPlayer)this.player).getVersion().getNetworkId() >= ProtocolVersion.V1_21_4.getNetworkId() ? addPlayer_1_21_4 : (((BungeeTabPlayer)this.player).getVersion().getNetworkId() >= ProtocolVersion.V1_21_2.getNetworkId() ? addPlayer_1_21_2 : addPlayer_legacy);
        this.sendPacket(actions, this.entryToItem(id, name, skin, listed, latency, gameMode, displayName, listOrder, showHat));
    }

    private void sendPacket(@NonNull EnumSet<PlayerListItemUpdate.Action> actions, @NonNull PlayerListItem.Item item) {
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PlayerListItemUpdate packet = new PlayerListItemUpdate();
        packet.setActions(actions);
        packet.setItems(new PlayerListItem.Item[]{item});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)packet);
    }
}

