/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeeTabList17
extends BungeeTabList {
    @NotNull
    private final Map<UUID, String> userNames = new HashMap<UUID, String>();
    @NotNull
    private final Map<UUID, BaseComponent> displayNames = new HashMap<UUID, BaseComponent>();

    public BungeeTabList17(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.removeUuid(entry);
        this.update(PlayerListItem.Action.REMOVE_PLAYER, this.createItem(null, this.displayNames.get(entry), 0));
        this.userNames.remove(entry);
        this.displayNames.remove(entry);
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable BaseComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.update(PlayerListItem.Action.REMOVE_PLAYER, this.createItem(null, this.displayNames.get(entry), 0));
        this.addEntry(entry, this.userNames.get(entry), (TabList.Skin)null, false, 0, 0, displayName, 0, false);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        this.update(PlayerListItem.Action.UPDATE_LATENCY, this.createItem(null, this.displayNames.get(entry), latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable BaseComponent displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.addUuid(id);
        this.update(PlayerListItem.Action.ADD_PLAYER, this.createItem(name, (BaseComponent)(displayName == null ? new TextComponent(name) : displayName), latency));
        this.userNames.put(id, name);
        this.displayNames.put(id, displayName);
    }

    @Override
    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
    }

    @Override
    public BaseComponent toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        String displayNameString = component.toLegacyText();
        if (displayNameString.length() > 16) {
            displayNameString = displayNameString.substring(0, 16);
        }
        return (BaseComponent)TabComponent.fromColoredText(displayNameString).convert(((BungeeTabPlayer)this.player).getVersion());
    }

    private void update(@NonNull PlayerListItem.Action action, @NonNull PlayerListItem.Item item) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PlayerListItem packet = new PlayerListItem();
        packet.setAction(action);
        packet.setItems(new PlayerListItem.Item[]{item});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)packet);
    }

    private PlayerListItem.Item createItem(@Nullable String username, @NonNull BaseComponent displayName, int latency) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUsername(username);
        item.setPing(Integer.valueOf(latency));
        item.setDisplayName(displayName);
        return item;
    }
}

