/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import me.neznamy.tab.platforms.fabric.FabricBossBar;
import me.neznamy.tab.platforms.fabric.FabricEventListener;
import me.neznamy.tab.platforms.fabric.FabricMultiVersion;
import me.neznamy.tab.platforms.fabric.FabricPipelineInjector;
import me.neznamy.tab.platforms.fabric.FabricScoreboard;
import me.neznamy.tab.platforms.fabric.FabricTAB;
import me.neznamy.tab.platforms.fabric.FabricTabList;
import me.neznamy.tab.platforms.fabric.FabricTabPlayer;
import me.neznamy.tab.platforms.fabric.hook.FabricTabExpansion;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricPlatform
implements BackendPlatform {
    private final MinecraftServer server;
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(FabricTAB.minecraftVersion);

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        if (!FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            this.registerDummyPlaceholder(identifier);
            return;
        }
        PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
        int refresh = manager.getRefreshInterval(identifier);
        manager.registerPlayerPlaceholder(identifier, refresh, p -> Placeholders.parseText((class_2561)FabricMultiVersion.newTextComponent(identifier), (PlaceholderContext)PlaceholderContext.of((class_3222)((class_3222)p.getPlayer()))).getString());
    }

    @Override
    public void loadPlayers() {
        for (class_3222 player : this.getOnlinePlayers()) {
            TAB.getInstance().addPlayer(new FabricTabPlayer(this, player));
        }
    }

    private Collection<class_3222> getOnlinePlayers() {
        return this.server.method_3760() == null ? Collections.emptyList() : this.server.method_3760().method_14571();
    }

    @Override
    @NotNull
    public PipelineInjector createPipelineInjector() {
        return new FabricPipelineInjector();
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            return new FabricTabExpansion();
        }
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        FabricMultiVersion.logInfo(message);
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        FabricMultiVersion.logWarn(message);
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Fabric] " + FabricTAB.minecraftVersion;
    }

    @Override
    public void registerListener() {
        new FabricEventListener().register();
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return FabricLoader.getInstance().getConfigDir().resolve("tab").toFile();
    }

    @NotNull
    public class_2561 convertComponent(@NotNull TabComponent component, boolean modern) {
        if (component instanceof SimpleComponent) {
            return FabricMultiVersion.newTextComponent(((SimpleComponent)component).getText());
        }
        StructuredComponent component1 = (StructuredComponent)component;
        class_2561 nmsComponent = FabricMultiVersion.newTextComponent(component1.getText());
        FabricMultiVersion.setStyle(nmsComponent, FabricMultiVersion.convertModifier(component1.getModifier(), modern));
        for (StructuredComponent extra : component1.getExtra()) {
            FabricMultiVersion.addSibling(nmsComponent, this.convertComponent(extra, modern));
        }
        return nmsComponent;
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new FabricScoreboard((FabricTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new FabricBossBar((FabricTabPlayer)player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new FabricTabList((FabricTabPlayer)player);
    }

    @Override
    public boolean supportsNumberFormat() {
        return this.serverVersion.getNetworkId() >= ProtocolVersion.V1_20_3.getNetworkId();
    }

    @Override
    public boolean supportsListOrder() {
        return this.serverVersion.getNetworkId() >= ProtocolVersion.V1_21_2.getNetworkId();
    }

    @Override
    public double getTPS() {
        return -1.0;
    }

    @Override
    public double getMSPT() {
        return FabricMultiVersion.getMSPT(this.server);
    }

    public FabricPlatform(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

