/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import me.neznamy.tab.platforms.fabric.FabricMultiVersion;
import me.neznamy.tab.platforms.fabric.FabricPlatform;
import me.neznamy.tab.platforms.fabric.hook.PermissionsAPIHook;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class FabricTabCommand {
    public void onRegisterCommands(@NotNull CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)class_2170.method_9247((String)"tab").executes(context -> this.executeCommand((class_2168)context.getSource(), new String[0]))).build();
        ArgumentCommandNode args = ((RequiredArgumentBuilder)class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> this.getSuggestions((class_2168)context.getSource(), this.getArguments((CommandContext<class_2168>)context), builder)).executes(context -> this.executeCommand((class_2168)context.getSource(), this.getArguments((CommandContext<class_2168>)context)))).build();
        command.addChild((CommandNode)args);
        dispatcher.getRoot().addChild((CommandNode)command);
    }

    @NotNull
    private String[] getArguments(@NotNull CommandContext<class_2168> context) {
        String input = context.getInput();
        int firstSpace = input.indexOf(32);
        if (firstSpace == -1) {
            return new String[0];
        }
        String rawArgs = input.substring(firstSpace + 1);
        String[] args = rawArgs.split(" ");
        if (rawArgs.endsWith(" ")) {
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = "";
        }
        return args;
    }

    private int executeCommand(@NotNull class_2168 source, @NotNull String[] args) {
        if (TAB.getInstance().isPluginDisabled()) {
            boolean hasReloadPermission = PermissionsAPIHook.hasPermission(source, "tab.reload");
            boolean hasAdminPermission = PermissionsAPIHook.hasPermission(source, "tab.admin");
            for (String message : TAB.getInstance().getDisabledCommand().execute(args, hasReloadPermission, hasAdminPermission)) {
                FabricMultiVersion.sendMessage(source, (class_2561)TabComponent.fromColoredText(message).convert(((FabricPlatform)TAB.getInstance().getPlatform()).getServerVersion()));
            }
        } else if (source.method_9228() == null) {
            TAB.getInstance().getCommand().execute(null, args);
        } else {
            TabPlayer player = TAB.getInstance().getPlayer(source.method_9228().method_5667());
            if (player != null) {
                TAB.getInstance().getCommand().execute(player, args);
            }
        }
        return 0;
    }

    @NotNull
    private CompletableFuture<Suggestions> getSuggestions(@NotNull class_2168 source, @NotNull String[] args, @NotNull SuggestionsBuilder builder) {
        TabPlayer player = null;
        if (source.method_9228() != null && (player = TAB.getInstance().getPlayer(source.method_9228().method_5667())) == null) {
            return Suggestions.empty();
        }
        SuggestionsBuilder newBuilder = builder;
        int lastSpace = newBuilder.getRemaining().lastIndexOf(32);
        if (lastSpace != -1) {
            newBuilder = newBuilder.createOffset(lastSpace + 1 + newBuilder.getStart());
        }
        for (String suggestion : TAB.getInstance().getCommand().complete(player, args)) {
            newBuilder.suggest(suggestion);
        }
        return newBuilder.buildFuture();
    }
}

