/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.fabric.FabricMultiVersion;
import me.neznamy.tab.platforms.fabric.FabricTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricTabList
extends TrackedTabList<FabricTabPlayer, class_2561> {
    public FabricTabList(@NotNull FabricTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.REMOVE_PLAYER, new Builder(entry, "", null, false, 0, 0, null, 0, false)));
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable class_2561 displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_DISPLAY_NAME, new Builder(entry, "", null, false, 0, 0, displayName, 0, false)));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_LATENCY, new Builder(entry, "", null, false, latency, 0, null, 0, false)));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_GAME_MODE, new Builder(entry, "", null, false, 0, gameMode, null, 0, false)));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (((FabricTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_19_3.getNetworkId()) {
            ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_LISTED, new Builder(entry, "", null, listed, 0, 0, null, 0, false)));
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (((FabricTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_21_2.getNetworkId()) {
            ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_LIST_ORDER, new Builder(entry, "", null, false, 0, 0, null, listOrder, false)));
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (((FabricTabPlayer)this.player).getPlatform().getServerVersion().getNetworkId() >= ProtocolVersion.V1_21_4.getNetworkId()) {
            ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.UPDATE_HAT, new Builder(entry, "", null, false, 0, 0, null, 0, showHat)));
        }
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable class_2561 displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.buildTabListPacket(TabList.Action.ADD_PLAYER, new Builder(id, name, skin, listed, latency, gameMode, displayName, listOrder, showHat)));
    }

    @Override
    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((FabricTabPlayer)this.player).sendPacket(FabricMultiVersion.newHeaderFooter((class_2561)this.toComponent(header), (class_2561)this.toComponent(footer)));
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return true;
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (FabricMultiVersion.isPlayerInfo((class_2596)packet)) {
            FabricMultiVersion.onPlayerInfo(this.player, packet);
        }
    }

    public static class Builder {
        @NonNull
        private final UUID id;
        @NonNull
        private String name;
        @Nullable
        private TabList.Skin skin;
        private boolean listed;
        private int latency;
        private int gameMode;
        @Nullable
        private class_2561 displayName;
        private int listOrder;
        private boolean showHat;

        @NotNull
        public GameProfile createProfile() {
            GameProfile profile = new GameProfile(this.id, this.name);
            if (this.skin != null) {
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", this.skin.getValue(), this.skin.getSignature()));
            }
            return profile;
        }

        public Builder(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable class_2561 displayName, int listOrder, boolean showHat) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.id = id;
            this.name = name;
            this.skin = skin;
            this.listed = listed;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
            this.listOrder = listOrder;
            this.showHat = showHat;
        }

        @NonNull
        public UUID getId() {
            return this.id;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public TabList.Skin getSkin() {
            return this.skin;
        }

        public boolean isListed() {
            return this.listed;
        }

        public int getLatency() {
            return this.latency;
        }

        public int getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public int getListOrder() {
            return this.listOrder;
        }

        public boolean isShowHat() {
            return this.showHat;
        }
    }
}

