/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric.hook;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.platforms.fabric.FabricMultiVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class FabricTabExpansion
implements TabExpansion {
    public FabricTabExpansion() {
        List<String> placeholders = Arrays.asList("tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "tabprefix_raw", "tabsuffix_raw", "tagprefix_raw", "tagsuffix_raw", "customtabname_raw", "scoreboard_name", "scoreboard_visible", "bossbar_visible", "nametag_visibility");
        for (String placeholder : placeholders) {
            this.registerPlaceholder(placeholder, (ctx, arg) -> {
                if (!ctx.hasPlayer()) {
                    return PlaceholderResult.invalid((String)"No player!");
                }
                TabPlayer player = TAB.getInstance().getPlayer(ctx.player().method_5667());
                return PlaceholderResult.value((String)player.expansionValues.get(placeholder));
            });
        }
        this.registerPlaceholder("replace", (ctx, arg) -> {
            String textBefore;
            if (!ctx.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            if (arg == null) {
                return PlaceholderResult.invalid((String)"No placeholder!");
            }
            Object text = "%" + arg + "%";
            do {
                textBefore = text;
                for (String placeholder : PlaceholderManagerImpl.detectPlaceholders((String)text)) {
                    text = ((String)text).replace(placeholder, TAB.getInstance().getPlaceholderManager().findReplacement(placeholder, Placeholders.parseText((class_2561)FabricMultiVersion.newTextComponent(placeholder), (PlaceholderContext)PlaceholderContext.of((class_3222)ctx.player())).getString()));
                }
            } while (!textBefore.equals(text));
            return PlaceholderResult.value((String)text);
        });
        this.registerPlaceholder("placeholder", (ctx, arg) -> {
            if (arg == null) {
                return PlaceholderResult.invalid((String)"No placeholder!");
            }
            TabPlayer player = ctx.hasPlayer() ? TAB.getInstance().getPlayer(ctx.player().method_5667()) : null;
            String placeholder = "%" + arg + "%";
            PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
            manager.addUsedPlaceholder(placeholder, manager);
            return PlaceholderResult.value((String)manager.getPlaceholder(placeholder).getLastValue(player));
        });
    }

    private void registerPlaceholder(String identifier, PlaceholderHandler handler) {
        Placeholders.register((class_2960)class_2960.method_12829((String)("tab:" + identifier)), (PlaceholderHandler)handler);
    }

    @Override
    public void setValue(@NotNull TabPlayer player, @NotNull String key, @NotNull String value) {
        player.expansionValues.put(key, value);
    }

    @Override
    public void unregisterExpansion() {
    }
}

