/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.paper;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;

public class PaperPacketScoreboard
extends SafeScoreboard<BukkitTabPlayer> {
    private static final ChatFormatting[] formats = ChatFormatting.values();
    private static final Team.CollisionRule[] collisions = Team.CollisionRule.values();
    private static final Team.Visibility[] visibilities = Team.Visibility.values();
    private static final Scoreboard dummyScoreboard = new Scoreboard();
    private static final Field method;
    private static final Field players;

    public PaperPacketScoreboard(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = new Objective(dummyScoreboard, objective.getName(), ObjectiveCriteria.DUMMY, (Component)objective.getTitle().convert(((BukkitTabPlayer)this.player).getVersion()), ObjectiveCriteria.RenderType.values()[objective.getHealthDisplay().ordinal()], false, objective.getNumberFormat() == null ? null : (NumberFormat)objective.getNumberFormat().toFixedFormat(FixedFormat::new));
        objective.setPlatformObjective(obj);
        this.sendPacket((Packet<?>)new ClientboundSetObjectivePacket(obj, 0));
        this.sendPacket((Packet<?>)new ClientboundSetDisplayObjectivePacket(DisplaySlot.values()[objective.getDisplaySlot().ordinal()], obj));
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundSetObjectivePacket((Objective)objective.getPlatformObjective(), 1));
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = (Objective)objective.getPlatformObjective();
        obj.setDisplayName((Component)objective.getTitle().convert(((BukkitTabPlayer)this.player).getVersion()));
        obj.setRenderType(ObjectiveCriteria.RenderType.values()[objective.getHealthDisplay().ordinal()]);
        this.sendPacket((Packet<?>)new ClientboundSetObjectivePacket(obj, 2));
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundSetScorePacket(score.getHolder(), score.getObjective().getName(), score.getValue(), Optional.ofNullable(score.getDisplayName() == null ? null : (Component)score.getDisplayName().convert(((BukkitTabPlayer)this.player).getVersion())), Optional.ofNullable(score.getNumberFormat() == null ? null : (NumberFormat)score.getNumberFormat().toFixedFormat(FixedFormat::new))));
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundResetScorePacket(score.getHolder(), score.getObjective().getName()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new PlayerTeam(dummyScoreboard, name);
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        PlayerTeam t = (PlayerTeam)team.getPlatformTeam();
        t.getPlayers().addAll(team.getPlayers());
        this.sendPacket((Packet<?>)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)t, (boolean)true));
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)ClientboundSetPlayerTeamPacket.createRemovePacket((PlayerTeam)((PlayerTeam)team.getPlatformTeam())));
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        this.updateTeamProperties(team);
        this.sendPacket((Packet<?>)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)((PlayerTeam)team.getPlatformTeam()), (boolean)false));
    }

    private void updateTeamProperties(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        PlayerTeam t = (PlayerTeam)team.getPlatformTeam();
        t.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        t.setSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        t.setColor(formats[team.getColor().ordinal()]);
        t.setCollisionRule(collisions[team.getCollision().ordinal()]);
        t.setNameTagVisibility(visibilities[team.getVisibility().ordinal()]);
        t.setPlayerPrefix((Component)team.getPrefix().convert(((BukkitTabPlayer)this.player).getVersion()));
        t.setPlayerSuffix((Component)team.getSuffix().convert(((BukkitTabPlayer)this.player).getVersion()));
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (this.isAntiOverrideScoreboard()) {
            if (packet instanceof ClientboundSetDisplayObjectivePacket) {
                ClientboundSetDisplayObjectivePacket display = (ClientboundSetDisplayObjectivePacket)packet;
                TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, display.getSlot().ordinal(), display.getObjectiveName());
            }
            if (packet instanceof ClientboundSetObjectivePacket) {
                ClientboundSetObjectivePacket objective = (ClientboundSetObjectivePacket)packet;
                TAB.getInstance().getFeatureManager().onObjective(this.player, objective.getMethod(), objective.getObjectiveName());
            }
        }
        if (this.isAntiOverrideTeams() && packet instanceof ClientboundSetPlayerTeamPacket) {
            ClientboundSetPlayerTeamPacket team = (ClientboundSetPlayerTeamPacket)packet;
            int action = method.getInt(team);
            if (action == 2) {
                return;
            }
            players.set(team, this.onTeamPacket(action, team.getName(), team.getPlayers() == null ? Collections.emptyList() : team.getPlayers()));
        }
    }

    private void sendPacket(@NotNull Packet<?> packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().connection.sendPacket(packet);
    }

    static {
        try {
            method = ReflectionUtils.setAccessible(ClientboundSetPlayerTeamPacket.class.getDeclaredField("method"));
            players = ReflectionUtils.setAccessible(ClientboundSetPlayerTeamPacket.class.getDeclaredField("players"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

