/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.paper;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.tablist.TabListBase;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.world.level.GameType;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperPacketTabList
extends TabListBase<Component> {
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateDisplayName = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateLatency = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateGameMode = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateListed = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> updateListOrder = EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LIST_ORDER);
    private static final EnumSet<ClientboundPlayerInfoUpdatePacket.Action> addPlayer = EnumSet.allOf(ClientboundPlayerInfoUpdatePacket.Action.class);
    private static final Field entries;

    public PaperPacketTabList(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoRemovePacket(Collections.singletonList(entry)));
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable Component displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(updateDisplayName, new ClientboundPlayerInfoUpdatePacket.Entry(entry, null, false, 0, null, displayName, 0, null)));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(updateLatency, new ClientboundPlayerInfoUpdatePacket.Entry(entry, null, false, latency, null, null, 0, null)));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(updateGameMode, new ClientboundPlayerInfoUpdatePacket.Entry(entry, null, false, 0, GameType.byId((int)gameMode), null, 0, null)));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(updateListed, new ClientboundPlayerInfoUpdatePacket.Entry(entry, null, listed, 0, null, null, 0, null)));
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(updateListOrder, new ClientboundPlayerInfoUpdatePacket.Entry(entry, null, false, 0, null, null, listOrder, null)));
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable Component displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundPlayerInfoUpdatePacket(addPlayer, new ClientboundPlayerInfoUpdatePacket.Entry(id, this.createProfile(id, name, skin), listed, latency, GameType.byId((int)gameMode), displayName, listOrder, null)));
    }

    @Override
    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        this.sendPacket((Packet<?>)new ClientboundTabListPacket((Component)header.convert(((BukkitTabPlayer)this.player).getVersion()), (Component)footer.convert(((BukkitTabPlayer)this.player).getVersion())));
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket info = (ClientboundPlayerInfoUpdatePacket)packet;
            EnumSet actions = info.actions();
            ArrayList<ClientboundPlayerInfoUpdatePacket.Entry> updatedList = new ArrayList<ClientboundPlayerInfoUpdatePacket.Entry>();
            boolean rewritePacket = false;
            for (ClientboundPlayerInfoUpdatePacket.Entry nmsData : info.entries()) {
                int newLatency;
                Component expectedDisplayName;
                boolean rewriteEntry = false;
                Component displayName = nmsData.displayName();
                int latency = nmsData.latency();
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME) && (expectedDisplayName = (Component)this.getExpectedDisplayNames().get(nmsData.profileId())) != null) {
                    displayName = expectedDisplayName;
                    rewritePacket = true;
                    rewriteEntry = true;
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY) && (newLatency = TAB.getInstance().getFeatureManager().onLatencyChange(this.player, nmsData.profileId(), latency)) != latency) {
                    latency = newLatency;
                    rewritePacket = true;
                    rewriteEntry = true;
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER)) {
                    TAB.getInstance().getFeatureManager().onEntryAdd(this.player, nmsData.profileId(), nmsData.profile().getName());
                }
                updatedList.add(rewriteEntry ? new ClientboundPlayerInfoUpdatePacket.Entry(nmsData.profileId(), nmsData.profile(), nmsData.listed(), latency, nmsData.gameMode(), displayName, nmsData.listOrder(), nmsData.chatSession()) : nmsData);
            }
            if (rewritePacket) {
                entries.set(info, updatedList);
            }
        }
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        Collection col = ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getProfile().getProperties().get((Object)"textures");
        if (col.isEmpty()) {
            return null;
        }
        Property property = (Property)col.iterator().next();
        return new TabList.Skin(property.value(), property.signature());
    }

    @NotNull
    private GameProfile createProfile(@NotNull UUID id, @NotNull String name, @Nullable TabList.Skin skin) {
        GameProfile profile = new GameProfile(id, name);
        if (skin != null) {
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return profile;
    }

    private void sendPacket(@NotNull Packet<?> packet) {
        ((CraftPlayer)((BukkitTabPlayer)this.player).getPlayer()).getHandle().connection.sendPacket(packet);
    }

    static {
        try {
            entries = ReflectionUtils.setAccessible(ClientboundPlayerInfoUpdatePacket.class.getDeclaredField("entries"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

