/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge7;

import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.platforms.sponge7.SpongeTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.decorators.SafeBossBar;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.text.Text;

public class SpongeBossBar
extends SafeBossBar<ServerBossBar> {
    private static final BossBarColor[] colors = new BossBarColor[]{BossBarColors.PINK, BossBarColors.BLUE, BossBarColors.RED, BossBarColors.GREEN, BossBarColors.YELLOW, BossBarColors.PURPLE, BossBarColors.WHITE};
    private static final BossBarOverlay[] styles = new BossBarOverlay[]{BossBarOverlays.PROGRESS, BossBarOverlays.NOTCHED_6, BossBarOverlays.NOTCHED_10, BossBarOverlays.NOTCHED_12, BossBarOverlays.NOTCHED_20};
    @NotNull
    private final SpongeTabPlayer player;

    @Override
    @NotNull
    public ServerBossBar constructBossBar(@NotNull TabComponent title, float progress, @NotNull BarColor color, @NotNull BarStyle style) {
        return ServerBossBar.builder().name((Text)title.convert(this.player.getVersion())).color(colors[color.ordinal()]).overlay(styles[style.ordinal()]).percent(progress).build();
    }

    @Override
    public void create(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).addPlayer(this.player.getPlayer());
    }

    @Override
    public void updateTitle(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).setName((Text)bar.getTitle().convert(this.player.getVersion()));
    }

    @Override
    public void updateProgress(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).setPercent(bar.getProgress());
    }

    @Override
    public void updateStyle(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).setOverlay(styles[bar.getStyle().ordinal()]);
    }

    @Override
    public void updateColor(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).setColor(colors[bar.getColor().ordinal()]);
    }

    @Override
    public void remove(@NotNull SafeBossBar.BossBarInfo bar) {
        ((ServerBossBar)bar.getBossBar()).removePlayer(this.player.getPlayer());
    }

    public SpongeBossBar(@NotNull SpongeTabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }
}

