/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge7;

import me.neznamy.tab.platforms.sponge7.SpongePlatform;
import me.neznamy.tab.platforms.sponge7.SpongeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.EventListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class SpongeEventListener
implements EventListener<Player> {
    @Listener
    public void onQuit(ClientConnectionEvent.Disconnect event) {
        this.quit(event.getTargetEntity().getUniqueId());
    }

    @Listener
    public void onJoin(ClientConnectionEvent.Join event) {
        this.join(event.getTargetEntity());
    }

    @Listener
    public void onWorldChange(MoveEntityEvent.Teleport event, @First Player player) {
        this.worldChange(event.getTargetEntity().getUniqueId(), event.getTargetEntity().getWorld().getName());
    }

    @Listener
    public void onCommand(SendCommandEvent event, @First Player player) {
        if (this.command(player.getUniqueId(), event.getCommand())) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.PRE)
    public void onRespawn(RespawnPlayerEvent event) {
        this.replacePlayer(event.getTargetEntity().getUniqueId(), event.getTargetEntity());
    }

    @Override
    @NotNull
    public TabPlayer createPlayer(@NotNull Player player) {
        return new SpongeTabPlayer((SpongePlatform)TAB.getInstance().getPlatform(), player);
    }
}

