/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge7;

import java.io.File;
import me.neznamy.tab.platforms.sponge7.Sponge7TAB;
import me.neznamy.tab.platforms.sponge7.SpongeBossBar;
import me.neznamy.tab.platforms.sponge7.SpongeEventListener;
import me.neznamy.tab.platforms.sponge7.SpongeScoreboard;
import me.neznamy.tab.platforms.sponge7.SpongeTabCommand;
import me.neznamy.tab.platforms.sponge7.SpongeTabList;
import me.neznamy.tab.platforms.sponge7.SpongeTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PerWorldPlayerListConfiguration;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class SpongePlatform
implements BackendPlatform {
    @NotNull
    private final Sponge7TAB plugin;
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(Sponge.getGame().getPlatform().getMinecraftVersion().getName());

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        this.registerDummyPlaceholder(identifier);
    }

    @Override
    public void loadPlayers() {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            TAB.getInstance().addPlayer(new SpongeTabPlayer(this, player));
        }
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return null;
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList(@NotNull PerWorldPlayerListConfiguration configuration) {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        this.plugin.getLogger().info(message.toLegacyText());
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        this.plugin.getLogger().warn((Object)((Object)EnumChatFormat.RED) + message.toLegacyText());
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Sponge] " + Sponge.getPlatform().getMinecraftVersion().getName();
    }

    @Override
    public void registerListener() {
        Sponge.getGame().getEventManager().registerListeners((Object)this.plugin, (Object)new SpongeEventListener());
    }

    @Override
    public void registerCommand() {
        SpongeTabCommand cmd = new SpongeTabCommand();
        Sponge.getGame().getCommandManager().register((Object)this.plugin, (CommandCallable)CommandSpec.builder().arguments(new CommandElement[]{cmd, GenericArguments.remainingJoinedStrings((Text)Text.of((String)"arguments"))}).executor((CommandExecutor)cmd).build(), new String[]{"tab"});
    }

    @Override
    public void startMetrics() {
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getConfigDir();
    }

    @NotNull
    public Text convertComponent(@NotNull TabComponent component, boolean modern) {
        return Text.of((String)component.toLegacyText());
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        return new SpongeScoreboard((SpongeTabPlayer)player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new SpongeBossBar((SpongeTabPlayer)player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new SpongeTabList((SpongeTabPlayer)player);
    }

    @Override
    public boolean supportsNumberFormat() {
        return false;
    }

    @Override
    public boolean supportsListOrder() {
        return false;
    }

    @Override
    public double getTPS() {
        return Sponge.getServer().getTicksPerSecond();
    }

    @Override
    public double getMSPT() {
        return -1.0;
    }

    public SpongePlatform(@NotNull Sponge7TAB plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

