/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge7;

import lombok.NonNull;
import me.neznamy.tab.platforms.sponge7.SpongeTabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.api.text.Text;

public class SpongeScoreboard
extends SafeScoreboard<SpongeTabPlayer> {
    private static final CollisionRule[] collisionRules = new CollisionRule[]{CollisionRules.ALWAYS, CollisionRules.NEVER, CollisionRules.PUSH_OTHER_TEAMS, CollisionRules.PUSH_OWN_TEAM};
    private static final Visibility[] visibilities = new Visibility[]{Visibilities.ALWAYS, Visibilities.NEVER, Visibilities.HIDE_FOR_OTHER_TEAMS, Visibilities.HIDE_FOR_OWN_TEAM};
    private static final DisplaySlot[] displaySlots = new DisplaySlot[]{DisplaySlots.LIST, DisplaySlots.SIDEBAR, DisplaySlots.BELOW_NAME};
    private static final ObjectiveDisplayMode[] healthDisplays = new ObjectiveDisplayMode[]{ObjectiveDisplayModes.INTEGER, ObjectiveDisplayModes.HEARTS};
    private final Scoreboard sb = Scoreboard.builder().build();

    public SpongeScoreboard(@NonNull SpongeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        player.getPlayer().setScoreboard(this.sb);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = Objective.builder().name(objective.getName()).displayName((Text)Text.of((String)SpongeScoreboard.cutTo(objective.getTitle().toLegacyText(), 32))).objectiveDisplayMode(healthDisplays[objective.getHealthDisplay().ordinal()]).criterion(Criteria.DUMMY).build();
        this.sb.addObjective(obj);
        this.sb.updateDisplaySlot(obj, displaySlots[objective.getDisplaySlot().ordinal()]);
        objective.setPlatformObjective(obj);
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sb.removeObjective((Objective)objective.getPlatformObjective());
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = (Objective)objective.getPlatformObjective();
        obj.setDisplayName((Text)Text.of((String)SpongeScoreboard.cutTo(objective.getTitle().toLegacyText(), 32)));
        obj.setDisplayMode(healthDisplays[objective.getHealthDisplay().ordinal()]);
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        ((Objective)score.getObjective().getPlatformObjective()).getOrCreateScore((Text)Text.of((String)score.getHolder())).setScore(score.getValue());
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        ((Objective)score.getObjective().getPlatformObjective()).removeScore((Text)Text.of((String)score.getHolder()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new Object();
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        Team spongeTeam = Team.builder().name(team.getName()).displayName((Text)Text.of((String)team.getName())).prefix((Text)Text.of((String)SpongeScoreboard.cutTo(team.getPrefix().toLegacyText(), 32))).suffix((Text)Text.of((String)SpongeScoreboard.cutTo(team.getSuffix().toLegacyText(), 32))).allowFriendlyFire((team.getOptions() & 1) != 0).canSeeFriendlyInvisibles((team.getOptions() & 2) != 0).collisionRule(collisionRules[team.getCollision().ordinal()]).nameTagVisibility(visibilities[team.getVisibility().ordinal()]).build();
        for (String member : team.getPlayers()) {
            spongeTeam.addMember((Text)Text.of((String)member));
        }
        this.sb.registerTeam(spongeTeam);
        team.setPlatformTeam(this.sb);
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((Team)team.getPlatformTeam()).unregister();
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        Team spongeTeam = (Team)team.getPlatformTeam();
        spongeTeam.setDisplayName((Text)Text.of((String)team.getName()));
        spongeTeam.setPrefix((Text)Text.of((String)SpongeScoreboard.cutTo(team.getPrefix().toLegacyText(), 32)));
        spongeTeam.setSuffix((Text)Text.of((String)SpongeScoreboard.cutTo(team.getSuffix().toLegacyText(), 32)));
        spongeTeam.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        spongeTeam.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        spongeTeam.setCollisionRule(collisionRules[team.getCollision().ordinal()]);
        spongeTeam.setNameTagVisibility(visibilities[team.getVisibility().ordinal()]);
    }
}

