/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge7;

import java.util.Collection;
import me.neznamy.tab.platforms.sponge7.SpongePlatform;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.text.Text;

public class SpongeTabPlayer
extends BackendTabPlayer {
    public SpongeTabPlayer(@NotNull SpongePlatform platform, @NotNull Player player) {
        super(platform, player, player.getUniqueId(), player.getName(), player.getWorld().getName(), platform.getServerVersion().getNetworkId());
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().getConnection().getLatency();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage((Text)Text.of((String)message.toLegacyText()));
    }

    @Override
    public boolean hasInvisibilityPotion() {
        PotionEffectData potionEffects = this.getPlayer().get(PotionEffectData.class).orElse(null);
        if (potionEffects == null) {
            return false;
        }
        return potionEffects.asList().stream().anyMatch(effect -> effect.getType().equals((Object)PotionEffectTypes.INVISIBILITY));
    }

    @Override
    public boolean isDisguised() {
        return false;
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        Collection properties = this.getPlayer().getProfile().getPropertyMap().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        ProfileProperty property = (ProfileProperty)properties.iterator().next();
        return new TabList.Skin(property.getValue(), property.getSignature().orElse(null));
    }

    @NotNull
    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public SpongePlatform getPlatform() {
        return (SpongePlatform)this.platform;
    }

    @Override
    public boolean isVanished0() {
        return this.getPlayer().get(Keys.VANISH).orElse(false);
    }

    @Override
    public int getGamemode() {
        GameMode gameMode = (GameMode)this.getPlayer().getGameModeData().type().get();
        if (gameMode.equals((Object)GameModes.CREATIVE)) {
            return 1;
        }
        if (gameMode.equals((Object)GameModes.ADVENTURE)) {
            return 2;
        }
        if (gameMode.equals((Object)GameModes.SPECTATOR)) {
            return 3;
        }
        return 0;
    }

    @Override
    public double getHealth() {
        return (Double)this.getPlayer().health().get();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return ((Text)this.getPlayer().getDisplayNameData().displayName().get()).toPlain();
    }
}

