/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import me.neznamy.tab.platforms.sponge8.SpongeMultiVersion;
import me.neznamy.tab.platforms.sponge8.SpongePlatform;
import me.neznamy.tab.platforms.sponge8.SpongeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.EventListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.ExecuteCommandEvent;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;

public class SpongeEventListener
implements EventListener<ServerPlayer> {
    @Listener
    public void onQuit(ServerSideConnectionEvent.Disconnect event) {
        this.quit(SpongeMultiVersion.getUniqueId.apply(event));
    }

    @Listener
    public void onJoin(ServerSideConnectionEvent.Join event) {
        this.join(event.player());
    }

    @Listener
    public void onWorldChange(ChangeEntityWorldEvent event, @First Player player) {
        this.worldChange(event.entity().uniqueId(), event.destinationWorld().toString());
    }

    @Listener
    public void onCommand(ExecuteCommandEvent.Pre event, @First Player player) {
        if (this.command(player.uniqueId(), event.command())) {
            event.setCancelled(true);
        }
    }

    @Listener(order=Order.PRE)
    public void onRespawn(RespawnPlayerEvent.Recreate event) {
        this.replacePlayer(event.recreatedPlayer().uniqueId(), event.recreatedPlayer());
    }

    @Override
    @NotNull
    public TabPlayer createPlayer(@NotNull ServerPlayer player) {
        return new SpongeTabPlayer((SpongePlatform)TAB.getInstance().getPlatform(), player);
    }
}

