/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import java.util.function.Supplier;
import lombok.NonNull;
import me.neznamy.tab.platforms.sponge8.SpongeMultiVersion;
import me.neznamy.tab.platforms.sponge8.SpongeTabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.scoreboard.criteria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;

public class SpongeScoreboard
extends SafeScoreboard<SpongeTabPlayer> {
    private static final CollisionRule[] collisionRules = new CollisionRule[]{(CollisionRule)CollisionRules.ALWAYS.get(), (CollisionRule)CollisionRules.NEVER.get(), (CollisionRule)CollisionRules.PUSH_OTHER_TEAMS.get(), (CollisionRule)CollisionRules.PUSH_OWN_TEAM.get()};
    private static final Visibility[] visibilities = new Visibility[]{(Visibility)Visibilities.ALWAYS.get(), (Visibility)Visibilities.NEVER.get(), (Visibility)Visibilities.HIDE_FOR_OTHER_TEAMS.get(), (Visibility)Visibilities.HIDE_FOR_OWN_TEAM.get()};
    private static final DisplaySlot[] displaySlots = new DisplaySlot[]{(DisplaySlot)DisplaySlots.LIST.get(), (DisplaySlot)DisplaySlots.SIDEBAR.get(), (DisplaySlot)DisplaySlots.BELOW_NAME.get()};
    private static final ObjectiveDisplayMode[] healthDisplays = new ObjectiveDisplayMode[]{(ObjectiveDisplayMode)ObjectiveDisplayModes.INTEGER.get(), (ObjectiveDisplayMode)ObjectiveDisplayModes.HEARTS.get()};
    private final Scoreboard sb = Scoreboard.builder().build();

    public SpongeScoreboard(@NonNull SpongeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        player.getPlayer().setScoreboard(this.sb);
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = Objective.builder().name(objective.getName()).displayName(objective.getTitle().toAdventure(((SpongeTabPlayer)this.player).getVersion())).objectiveDisplayMode(healthDisplays[objective.getHealthDisplay().ordinal()]).criterion((Supplier)Criteria.DUMMY).build();
        this.sb.addObjective(obj);
        this.sb.updateDisplaySlot(obj, displaySlots[objective.getDisplaySlot().ordinal()]);
        objective.setPlatformObjective(obj);
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sb.removeObjective((Objective)objective.getPlatformObjective());
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        Objective obj = (Objective)objective.getPlatformObjective();
        obj.setDisplayName(objective.getTitle().toAdventure(((SpongeTabPlayer)this.player).getVersion()));
        obj.setDisplayMode(healthDisplays[objective.getHealthDisplay().ordinal()]);
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        Objective obj = (Objective)score.getObjective().getPlatformObjective();
        SpongeMultiVersion.findOrCreateScore(obj, score.getHolder()).setScore(score.getValue());
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        Objective obj = (Objective)score.getObjective().getPlatformObjective();
        obj.removeScore(SpongeMultiVersion.findOrCreateScore(obj, score.getHolder()));
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new Object();
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        Team spongeTeam = Team.builder().name(team.getName()).displayName((Component)Component.text((String)team.getName())).prefix(team.getPrefix().toAdventure(((SpongeTabPlayer)this.player).getVersion())).suffix(team.getSuffix().toAdventure(((SpongeTabPlayer)this.player).getVersion())).color((NamedTextColor)NamedTextColor.NAMES.valueOr((Object)team.getColor().name(), (Object)NamedTextColor.WHITE)).allowFriendlyFire((team.getOptions() & 1) != 0).canSeeFriendlyInvisibles((team.getOptions() & 2) != 0).collisionRule(collisionRules[team.getCollision().ordinal()]).nameTagVisibility(visibilities[team.getVisibility().ordinal()]).build();
        for (String member : team.getPlayers()) {
            spongeTeam.addMember((Component)Component.text((String)member));
        }
        this.sb.registerTeam(spongeTeam);
        team.setPlatformTeam(spongeTeam);
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((Team)team.getPlatformTeam()).unregister();
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        Team spongeTeam = (Team)team.getPlatformTeam();
        spongeTeam.setDisplayName((Component)Component.text((String)team.getName()));
        spongeTeam.setPrefix(team.getPrefix().toAdventure(((SpongeTabPlayer)this.player).getVersion()));
        spongeTeam.setSuffix(team.getSuffix().toAdventure(((SpongeTabPlayer)this.player).getVersion()));
        spongeTeam.setColor((NamedTextColor)NamedTextColor.NAMES.valueOr((Object)team.getColor().name(), (Object)NamedTextColor.WHITE));
        spongeTeam.setAllowFriendlyFire((team.getOptions() & 1) != 0);
        spongeTeam.setCanSeeFriendlyInvisibles((team.getOptions() & 2) != 0);
        spongeTeam.setCollisionRule(collisionRules[team.getCollision().ordinal()]);
        spongeTeam.setNameTagVisibility(visibilities[team.getVisibility().ordinal()]);
    }
}

