/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.sponge8.SpongeTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SpongeTabList
extends TrackedTabList<SpongeTabPlayer, Component> {
    private static final GameMode[] gameModes = new GameMode[]{(GameMode)GameModes.SURVIVAL.get(), (GameMode)GameModes.CREATIVE.get(), (GameMode)GameModes.ADVENTURE.get(), (GameMode)GameModes.SPECTATOR.get()};

    public SpongeTabList(@NotNull SpongeTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().removeEntry(entry);
    }

    @Override
    public void updateDisplayName(@NonNull UUID entry, @Nullable Component displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setDisplayName(displayName));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setLatency(latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).ifPresent(e -> e.setGameMode(gameModes[gameMode]));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListOrder(@NonNull UUID entry, int listOrder) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateHat(@NonNull UUID entry, boolean showHat) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable Component displayName, int listOrder, boolean showHat) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        GameProfile profile = GameProfile.of((UUID)id, (String)name);
        if (skin != null) {
            profile = profile.withProperty(ProfileProperty.of((String)"textures", (String)skin.getValue(), (String)skin.getSignature()));
        }
        TabListEntry tabListEntry = TabListEntry.builder().list(((SpongeTabPlayer)this.player).getPlayer().tabList()).profile(profile).latency(latency).gameMode(gameModes[gameMode]).displayName(displayName).build();
        ((SpongeTabPlayer)this.player).getPlayer().tabList().addEntry(tabListEntry);
    }

    @Override
    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((SpongeTabPlayer)this.player).getPlayer().tabList().setHeaderAndFooter(header.toAdventure(((SpongeTabPlayer)this.player).getVersion()), footer.toAdventure(((SpongeTabPlayer)this.player).getVersion()));
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return ((SpongeTabPlayer)this.player).getPlayer().tabList().entry(entry).isPresent();
    }

    @Override
    public void checkDisplayNames() {
        for (TabListEntry entry : ((SpongeTabPlayer)this.player).getPlayer().tabList().entries()) {
            Component expectedComponent = (Component)this.getExpectedDisplayNames().get(entry.profile().uniqueId());
            if (expectedComponent == null || entry.displayName().orElse(null) == expectedComponent) continue;
            entry.setDisplayName(expectedComponent);
        }
    }
}

