/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.platforms.velocity.VelocityPlatform;
import me.neznamy.tab.platforms.velocity.VelocityScoreboard;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.platform.EventListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.SafeBossBar;
import org.jetbrains.annotations.NotNull;

public class VelocityEventListener
implements EventListener<Player> {
    private final Map<Player, UUID> players = new ConcurrentHashMap<Player, UUID>();

    @Subscribe
    public void onQuit(@NotNull DisconnectEvent e) {
        UUID id = this.players.remove(e.getPlayer());
        if (id != null) {
            this.quit(id);
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void preConnect(@NotNull ServerPreConnectEvent e) {
        TabPlayer p;
        if (e.getResult().isAllowed() && (p = TAB.getInstance().getPlayer(e.getPlayer().getUniqueId())) != null && p.getVersion().getNetworkId() >= ProtocolVersion.V1_20_2.getNetworkId()) {
            ((SafeBossBar)p.getBossBar()).freeze();
        }
    }

    @Subscribe
    public void onConnect(@NotNull ServerPostConnectEvent e) {
        TAB tab = TAB.getInstance();
        if (tab.isPluginDisabled()) {
            return;
        }
        tab.getCPUManager().runTask(() -> {
            TabPlayer player = tab.getPlayer(e.getPlayer().getUniqueId());
            if (player == null) {
                this.players.put(e.getPlayer(), e.getPlayer().getUniqueId());
                tab.getFeatureManager().onJoin(this.createPlayer(e.getPlayer()));
            } else {
                if (!(player.getScoreboard() instanceof VelocityScoreboard)) {
                    player.getScoreboard().resend();
                }
                tab.getFeatureManager().onServerChange(player.getUniqueId(), e.getPlayer().getCurrentServer().map(s -> s.getServerInfo().getName()).orElse("null"));
                tab.getFeatureManager().onTabListClear(player);
                if (player.getVersion().getNetworkId() >= ProtocolVersion.V1_20_2.getNetworkId()) {
                    ((SafeBossBar)player.getBossBar()).unfreezeAndResend();
                }
            }
        });
    }

    @Subscribe
    public void onCommand(@NotNull CommandExecuteEvent e) {
        ScoreboardManagerImpl scoreboard;
        BossBarManagerImpl bossBarManager = (BossBarManagerImpl)TAB.getInstance().getFeatureManager().getFeature("BossBar");
        if (bossBarManager != null && bossBarManager.getCommand().substring(1).equals(e.getCommand())) {
            e.setResult(CommandExecuteEvent.CommandResult.command((String)"btab bossbar"));
        }
        if ((scoreboard = (ScoreboardManagerImpl)TAB.getInstance().getFeatureManager().getFeature("ScoreBoard")) != null && scoreboard.getCommand().substring(1).equals(e.getCommand())) {
            e.setResult(CommandExecuteEvent.CommandResult.command((String)"btab scoreboard"));
        }
    }

    @Subscribe
    public void onPluginMessageEvent(@NotNull PluginMessageEvent e) {
        if (!e.getIdentifier().getId().equals("tab:bridge-6")) {
            return;
        }
        if (e.getTarget() instanceof Player) {
            e.setResult(PluginMessageEvent.ForwardResult.handled());
            this.pluginMessage(((Player)e.getTarget()).getUniqueId(), e.getData());
        }
    }

    @Override
    @NotNull
    public TabPlayer createPlayer(@NotNull Player player) {
        return new VelocityTabPlayer((VelocityPlatform)TAB.getInstance().getPlatform(), player);
    }
}

