/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.scoreboard.ObjectiveEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.scoreboard.ScoreboardManager;
import java.io.File;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.velocity.VelocityEventListener;
import me.neznamy.tab.platforms.velocity.VelocityScoreboard;
import me.neznamy.tab.platforms.velocity.VelocityTAB;
import me.neznamy.tab.platforms.velocity.VelocityTabCommand;
import me.neznamy.tab.platforms.velocity.VelocityTabList;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.platforms.velocity.features.VelocityRedisSupport;
import me.neznamy.tab.platforms.velocity.hook.VelocityPremiumVanishHook;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.hook.AdventureHook;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.impl.AdventureBossBar;
import me.neznamy.tab.shared.platform.impl.DummyScoreboard;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityPlatform
extends ProxyPlatform {
    @NotNull
    private final VelocityTAB plugin;
    private boolean scoreboardAPI;
    private final MinecraftChannelIdentifier MCI = MinecraftChannelIdentifier.from((String)"tab:bridge-6");
    private static final ComponentLogger logger = ComponentLogger.logger((String)"TAB");

    public VelocityPlatform(@NotNull VelocityTAB plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().isLoaded("velocity-scoreboard-api")) {
            try {
                ScoreboardManager.getInstance();
                this.scoreboardAPI = true;
                plugin.getServer().getEventManager().register((Object)plugin, ObjectiveEvent.Display.class, e -> {
                    TAB tab = TAB.getInstance();
                    if (tab.isPluginDisabled()) {
                        return;
                    }
                    tab.getCPUManager().runTask(() -> {
                        TabPlayer player = tab.getPlayer(e.getPlayer().getUniqueId());
                        if (player != null) {
                            tab.getFeatureManager().onDisplayObjective(player, e.getNewSlot().ordinal(), e.getObjective().getName());
                        }
                    });
                });
                plugin.getServer().getEventManager().register((Object)plugin, ObjectiveEvent.Unregister.class, e -> {
                    TAB tab = TAB.getInstance();
                    if (tab.isPluginDisabled()) {
                        return;
                    }
                    tab.getCPUManager().runTask(() -> {
                        TabPlayer player = tab.getPlayer(e.getPlayer().getUniqueId());
                        if (player != null) {
                            tab.getFeatureManager().onObjective(player, 1, e.getObjective().getName());
                        }
                    });
                });
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.logInfo(TabComponent.fromColoredText(String.valueOf((Object)EnumChatFormat.RED) + "As of version 5.0.0, TAB no longer uses TAB-Bridge to encode scoreboard packets on Velocity. Instead, it uses a custom made plugin that adds scoreboard API directly to Velocity, which offers better performance and reliability. You can download the plugin from https://github.com/NEZNAMY/VelocityScoreboardAPI/releases/. Until then, the following features will not work: scoreboard-teams, belowname-objective, playerlist-objective, scoreboard"));
        }
        if (plugin.getServer().getPluginManager().isLoaded("premiumvanish")) {
            new VelocityPremiumVanishHook().register();
        }
    }

    @Override
    public void loadPlayers() {
        for (Player p : this.plugin.getServer().getAllPlayers()) {
            TAB.getInstance().addPlayer(new VelocityTabPlayer(this, p));
        }
    }

    @Override
    @Nullable
    public RedisSupport getRedisSupport() {
        if (ReflectionUtils.classExists("com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI") && RedisBungeeAPI.getRedisBungeeApi() != null) {
            return new VelocityRedisSupport(this.plugin);
        }
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        logger.info(message.toAdventure(ProtocolVersion.LATEST_KNOWN_VERSION));
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        logger.warn(message.toAdventure(ProtocolVersion.LATEST_KNOWN_VERSION));
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Velocity] " + this.plugin.getServer().getVersion().getName() + " - " + this.plugin.getServer().getVersion().getVersion();
    }

    @Override
    public void registerListener() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)new VelocityEventListener());
    }

    @Override
    public void registerCommand() {
        CommandManager cmd = this.plugin.getServer().getCommandManager();
        cmd.register(cmd.metaBuilder("btab").build(), (Command)new VelocityTabCommand());
    }

    @Override
    public void startMetrics() {
        this.plugin.getMetricsFactory().make(this.plugin, 10533).addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder().toFile();
    }

    @NotNull
    public Component convertComponent(@NotNull TabComponent component, boolean modern) {
        return AdventureHook.toAdventureComponent(component, modern);
    }

    @Override
    @NotNull
    public Scoreboard createScoreboard(@NotNull TabPlayer player) {
        if (this.scoreboardAPI) {
            return new VelocityScoreboard((VelocityTabPlayer)player);
        }
        return new DummyScoreboard(player);
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NotNull TabPlayer player) {
        return new AdventureBossBar(player);
    }

    @Override
    @NotNull
    public TabList createTabList(@NotNull TabPlayer player) {
        return new VelocityTabList((VelocityTabPlayer)player);
    }

    @Override
    public boolean supportsNumberFormat() {
        return true;
    }

    @Override
    public boolean supportsListOrder() {
        return true;
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return null;
    }

    @Override
    public void registerChannel() {
        this.plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.MCI});
    }

    @NotNull
    public VelocityTAB getPlugin() {
        return this.plugin;
    }

    public boolean isScoreboardAPI() {
        return this.scoreboardAPI;
    }

    public MinecraftChannelIdentifier getMCI() {
        return this.MCI;
    }
}

