/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.TextHolder;
import com.velocitypowered.api.scoreboard.CollisionRule;
import com.velocitypowered.api.scoreboard.DisplaySlot;
import com.velocitypowered.api.scoreboard.HealthDisplay;
import com.velocitypowered.api.scoreboard.NameVisibility;
import com.velocitypowered.api.scoreboard.NumberFormat;
import com.velocitypowered.api.scoreboard.ProxyObjective;
import com.velocitypowered.api.scoreboard.ProxyScoreboard;
import com.velocitypowered.api.scoreboard.ProxyTeam;
import com.velocitypowered.api.scoreboard.ScoreboardManager;
import com.velocitypowered.api.scoreboard.TeamColor;
import java.util.function.BiFunction;
import lombok.NonNull;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.decorators.SafeScoreboard;
import me.neznamy.tab.shared.util.cache.StringToComponentCache;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class VelocityScoreboard
extends SafeScoreboard<VelocityTabPlayer> {
    private static final BiFunction<TabComponent, ProtocolVersion, TextHolder> textHolderFunction = (component, version) -> TextHolder.of((String)component.toLegacyText(), (Component)component.toAdventure((ProtocolVersion)((Object)version)));
    private static final StringToComponentCache displayNames = new StringToComponentCache("Team display name", 5000);
    private static final TeamColor[] colors = TeamColor.values();
    private static final NameVisibility[] visibilities = NameVisibility.values();
    private static final CollisionRule[] collisions = CollisionRule.values();
    private final ProxyScoreboard scoreboard;

    public VelocityScoreboard(@NotNull VelocityTabPlayer player) {
        super(player);
        this.scoreboard = ScoreboardManager.getInstance().getProxyScoreboard(player.getPlayer());
    }

    @Override
    public void registerObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        try {
            ProxyObjective.Builder builder = this.scoreboard.objectiveBuilder(objective.getName()).displaySlot(DisplaySlot.valueOf((String)objective.getDisplaySlot().name())).healthDisplay(HealthDisplay.valueOf((String)objective.getHealthDisplay().name())).title(objective.getTitle().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).numberFormat(objective.getNumberFormat() == null ? null : NumberFormat.fixed((Component)objective.getNumberFormat().toAdventure(((VelocityTabPlayer)this.player).getVersion())));
            objective.setPlatformObjective(this.scoreboard.registerObjective(builder));
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to register objective " + objective.getName() + " for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    public void unregisterObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        try {
            this.scoreboard.unregisterObjective(objective.getName());
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to unregister objective " + objective.getName() + " for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    public void updateObjective(@NonNull SafeScoreboard.Objective objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        try {
            ProxyObjective obj = (ProxyObjective)objective.getPlatformObjective();
            obj.setHealthDisplay(HealthDisplay.valueOf((String)objective.getHealthDisplay().name()));
            obj.setTitle(objective.getTitle().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion()));
            obj.setNumberFormat(objective.getNumberFormat() == null ? null : NumberFormat.fixed((Component)objective.getNumberFormat().toAdventure(((VelocityTabPlayer)this.player).getVersion())));
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to update objective " + objective.getName() + " for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    public void setScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        try {
            ((ProxyObjective)score.getObjective().getPlatformObjective()).setScore(score.getHolder(), b -> b.score(score.getValue()).displayName(score.getDisplayName() == null ? null : score.getDisplayName().toAdventure(((VelocityTabPlayer)this.player).getVersion())).numberFormat(score.getNumberFormat() == null ? null : NumberFormat.fixed((Component)score.getNumberFormat().toAdventure(((VelocityTabPlayer)this.player).getVersion()))));
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to set score " + score.getHolder() + " for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    public void removeScore(@NonNull SafeScoreboard.Score score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        try {
            ((ProxyObjective)score.getObjective().getPlatformObjective()).removeScore(score.getHolder());
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to remove score " + score.getHolder() + " for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    @NotNull
    public Object createTeam(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this;
    }

    @Override
    public void registerTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        try {
            team.setPlatformTeam(this.scoreboard.registerTeam(this.scoreboard.teamBuilder(team.getName()).displayName(((TabComponent)displayNames.get(team.getName())).toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).prefix(team.getPrefix().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).suffix(team.getSuffix().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).nameVisibility(visibilities[team.getVisibility().ordinal()]).collisionRule(collisions[team.getCollision().ordinal()]).allowFriendlyFire((team.getOptions() & 1) > 0).canSeeFriendlyInvisibles((team.getOptions() & 2) > 0).color(colors[team.getColor().ordinal()]).entries(team.getPlayers())));
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Team " + team.getName() + " already existed with entry " + String.valueOf(this.scoreboard.getTeam(team.getName()).getEntries()) + " when registering for player " + ((VelocityTabPlayer)this.player).getName() + " with new entry " + String.valueOf(team.getPlayers()) + ", unregistering", e);
            this.unregisterTeam(team);
            this.registerTeam(team);
        }
    }

    @Override
    public void unregisterTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        try {
            this.scoreboard.unregisterTeam(team.getName());
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Team " + team.getName() + " did not exist when unregistering for player " + ((VelocityTabPlayer)this.player).getName(), e);
        }
    }

    @Override
    public void updateTeam(@NonNull SafeScoreboard.Team team) {
        if (team == null) {
            throw new NullPointerException("team is marked non-null but is null");
        }
        ((ProxyTeam)team.getPlatformTeam()).updateProperties(b -> b.prefix(team.getPrefix().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).suffix(team.getSuffix().toTextHolder(textHolderFunction, ((VelocityTabPlayer)this.player).getVersion())).nameVisibility(visibilities[team.getVisibility().ordinal()]).collisionRule(collisions[team.getCollision().ordinal()]).color(colors[team.getColor().ordinal()]).allowFriendlyFire((team.getOptions() & 1) > 0).canSeeFriendlyInvisibles((team.getOptions() & 2) > 0));
    }
}

