/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity.features;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.velocitypowered.api.event.Subscribe;
import me.neznamy.tab.platforms.velocity.VelocityTAB;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import org.jetbrains.annotations.NotNull;

public class VelocityRedisSupport
extends RedisSupport {
    @NotNull
    private final VelocityTAB plugin;

    @Subscribe
    public void onMessage(PubSubMessageEvent e) {
        if (!e.getChannel().equals("TAB")) {
            return;
        }
        this.processMessage(e.getMessage());
    }

    @Override
    public void register() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)this);
        RedisBungeeAPI.getRedisBungeeApi().registerPubSubChannels(new String[]{"TAB"});
    }

    @Override
    public void unregister() {
        this.plugin.getServer().getEventManager().unregisterListener((Object)this.plugin, (Object)this);
        RedisBungeeAPI.getRedisBungeeApi().unregisterPubSubChannels(new String[]{"TAB"});
    }

    @Override
    public void sendMessage(@NotNull String message) {
        try {
            RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage("TAB", message);
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().redisBungeeMessageSendFail(e);
        }
    }

    public VelocityRedisSupport(@NotNull VelocityTAB plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

