/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.files.Config;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import me.neznamy.tab.shared.cpu.TimedCaughtTask;
import me.neznamy.tab.shared.features.NickCompatibility;
import me.neznamy.tab.shared.features.SpectatorFix;
import me.neznamy.tab.shared.features.belowname.BelowName;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;
import me.neznamy.tab.shared.features.header.HeaderFooter;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.pingspoof.PingSpoof;
import me.neznamy.tab.shared.features.playerlist.PlayerList;
import me.neznamy.tab.shared.features.playerlistobjective.YellowNumber;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.features.sorting.Sorting;
import me.neznamy.tab.shared.features.types.CommandListener;
import me.neznamy.tab.shared.features.types.CustomThreaded;
import me.neznamy.tab.shared.features.types.DisplayObjectiveListener;
import me.neznamy.tab.shared.features.types.EntryAddListener;
import me.neznamy.tab.shared.features.types.GameModeListener;
import me.neznamy.tab.shared.features.types.GroupListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.LatencyListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.ObjectiveListener;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.RedisFeature;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.TabListClearListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.platform.decorators.TrackedTabList;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import me.neznamy.tab.shared.proxy.message.outgoing.Unload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureManager {
    private final Map<String, TabFeature> features = new LinkedHashMap<String, TabFeature>();
    @NotNull
    private TabFeature[] values = new TabFeature[0];
    private boolean hasLatencyChangeListener;
    private boolean hasCommandListener;
    private final List<String> listeningCommands = new ArrayList<String>();

    public void load() {
        for (TabFeature f : this.values) {
            if (!(f instanceof Loadable)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
                long time = System.currentTimeMillis();
                ((Loadable)((Object)f)).load();
                TAB.getInstance().debug("Feature " + f.getClass().getSimpleName() + " processed load in " + (System.currentTimeMillis() - time) + "ms");
            }, f.getFeatureName(), "Load");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        if (TAB.getInstance().getConfiguration().getUsers() instanceof MySQLUserConfiguration) {
            MySQLUserConfiguration users = (MySQLUserConfiguration)TAB.getInstance().getConfiguration().getUsers();
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                users.load(p);
            }
        }
    }

    public void unload() {
        for (TabFeature f : this.values) {
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().shutdown();
            }
            if (!(f instanceof UnLoadable)) continue;
            long time = System.currentTimeMillis();
            ((UnLoadable)((Object)f)).unload();
            TAB.getInstance().debug("Feature " + f.getClass().getSimpleName() + " processed unload in " + (System.currentTimeMillis() - time) + "ms");
        }
        for (TabFeature f : this.values) {
            f.deactivate();
        }
        long time = System.currentTimeMillis();
        for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
            player.getScoreboard().clear();
            player.getBossBar().clear();
        }
        TAB.getInstance().debug("Unregistered all scoreboard teams, objectives and boss bars for all players in " + (System.currentTimeMillis() - time) + "ms");
        TAB.getInstance().getPlaceholderManager().getTabExpansion().unregisterExpansion();
        if (TAB.getInstance().getPlatform() instanceof ProxyPlatform) {
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                ((ProxyTabPlayer)player).sendPluginMessage(new Unload());
            }
        }
    }

    public void onGroupChange(@NotNull TabPlayer player) {
        for (TabFeature f : this.values) {
            if (!(f instanceof GroupListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((GroupListener)((Object)f)).onGroupChange(player), f.getFeatureName(), "Processing group change");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onGameModeChange(@NotNull TabPlayer player) {
        for (TabFeature f : this.values) {
            if (!(f instanceof GameModeListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((GameModeListener)((Object)f)).onGameModeChange(player), f.getFeatureName(), "Processing gamemode change");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onQuit(@Nullable TabPlayer disconnectedPlayer) {
        if (disconnectedPlayer == null) {
            return;
        }
        disconnectedPlayer.markOffline();
        long millis = System.currentTimeMillis();
        for (TabFeature f : this.values) {
            if (!(f instanceof QuitListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((QuitListener)((Object)f)).onQuit(disconnectedPlayer), f.getFeatureName(), "Player Quit");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        TAB.getInstance().removePlayer(disconnectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            ((TrackedTabList)all.getTabList()).getExpectedDisplayNames().remove(disconnectedPlayer.getTablistId());
        }
        TAB.getInstance().debug("Player quit of " + disconnectedPlayer.getName() + " processed in " + (System.currentTimeMillis() - millis) + "ms");
    }

    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        long millis = System.currentTimeMillis();
        TAB.getInstance().addPlayer(connectedPlayer);
        for (TabFeature f : this.values) {
            if (!(f instanceof JoinListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> {
                long time = System.nanoTime();
                ((JoinListener)((Object)f)).onJoin(connectedPlayer);
                TAB.getInstance().debug("Feature " + f.getClass().getSimpleName() + " processed player join in " + (System.nanoTime() - time) / 1000000L + "ms");
            }, f.getFeatureName(), "Player Join");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        connectedPlayer.markAsLoaded(true);
        TAB.getInstance().debug("Player join of " + connectedPlayer.getName() + " processed in " + (System.currentTimeMillis() - millis) + "ms");
        if (TAB.getInstance().getConfiguration().getUsers() instanceof MySQLUserConfiguration) {
            MySQLUserConfiguration users = (MySQLUserConfiguration)TAB.getInstance().getConfiguration().getUsers();
            users.load(connectedPlayer);
        }
    }

    public void onWorldChange(@NotNull UUID playerUUID, @NotNull String to) {
        TabPlayer changed = TAB.getInstance().getPlayer(playerUUID);
        if (changed == null) {
            return;
        }
        String from = changed.world;
        changed.world = to;
        for (TabFeature f : this.values) {
            if (!(f instanceof WorldSwitchListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((WorldSwitchListener)((Object)f)).onWorldChange(changed, from, to), f.getFeatureName(), "World Switch");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%world%"))).updateValue(changed, to);
    }

    public void onServerChange(@NotNull UUID playerUUID, @NotNull String to) {
        TabPlayer changed = TAB.getInstance().getPlayer(playerUUID);
        if (changed == null) {
            return;
        }
        String from = changed.server;
        changed.server = to;
        ((ProxyTabPlayer)changed).sendJoinPluginMessage();
        for (TabFeature f : this.values) {
            if (!(f instanceof ServerSwitchListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((ServerSwitchListener)((Object)f)).onServerChange(changed, from, to), f.getFeatureName(), "Server Switch");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%server%"))).updateValue(changed, to);
    }

    public boolean onCommand(@Nullable TabPlayer sender, @NotNull String command) {
        if (!this.hasCommandListener || sender == null) {
            return false;
        }
        if (!this.listeningCommands.contains(command)) {
            return false;
        }
        boolean cancel = false;
        for (TabFeature f : this.values) {
            if (!(f instanceof CommandListener)) continue;
            long time = System.nanoTime();
            if (((CommandListener)((Object)f)).onCommand(sender, command)) {
                cancel = true;
            }
            TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), "Command Preprocess", System.nanoTime() - time);
        }
        return cancel;
    }

    public void onDisplayObjective(@NotNull TabPlayer packetReceiver, int slot, @NotNull String objective) {
        for (TabFeature f : this.values) {
            if (!(f instanceof DisplayObjectiveListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((DisplayObjectiveListener)((Object)f)).onDisplayObjective(packetReceiver, slot, objective), f.getFeatureName(), "Checking for other plugins");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onObjective(@NotNull TabPlayer packetReceiver, int action, @NotNull String objective) {
        for (TabFeature f : this.values) {
            if (!(f instanceof ObjectiveListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((ObjectiveListener)((Object)f)).onObjective(packetReceiver, action, objective), f.getFeatureName(), "Checking for other plugins");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onVanishStatusChange(@NotNull TabPlayer player) {
        for (TabFeature f : this.values) {
            if (!(f instanceof VanishListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((VanishListener)((Object)f)).onVanishStatusChange(player), f.getFeatureName(), "Vanish status change");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onEntryAdd(TabPlayer packetReceiver, UUID id, String name) {
        for (TabFeature f : this.values) {
            if (!(f instanceof EntryAddListener)) continue;
            long time = System.nanoTime();
            ((EntryAddListener)((Object)f)).onEntryAdd(packetReceiver, id, name);
            TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), "Compatibility with nick plugins", System.nanoTime() - time);
        }
    }

    public int onLatencyChange(TabPlayer packetReceiver, UUID id, int latency) {
        if (!this.hasLatencyChangeListener) {
            return latency;
        }
        int newLatency = latency;
        for (TabFeature f : this.values) {
            if (!(f instanceof LatencyListener)) continue;
            long time = System.nanoTime();
            newLatency = ((LatencyListener)((Object)f)).onLatencyChange(packetReceiver, id, newLatency);
            TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), "Processing ping change", System.nanoTime() - time);
        }
        return newLatency;
    }

    public void onTabListClear(TabPlayer packetReceiver) {
        for (TabFeature f : this.values) {
            if (!(f instanceof TabListClearListener)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((TabListClearListener)((Object)f)).onTabListClear(packetReceiver), f.getFeatureName(), "TabList entry re-add");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onRedisLoadRequest() {
        for (TabFeature f : this.values) {
            if (!(f instanceof RedisFeature)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((RedisFeature)((Object)f)).onRedisLoadRequest(), f.getFeatureName(), "Processing reload from another proxy");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onJoin(@NotNull RedisPlayer connectedPlayer) {
        for (TabFeature f : this.values) {
            if (!(f instanceof RedisFeature)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((RedisFeature)((Object)f)).onJoin(connectedPlayer), f.getFeatureName(), "Player Join");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onServerSwitch(@NotNull RedisPlayer player) {
        for (TabFeature f : this.values) {
            if (!(f instanceof RedisFeature)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((RedisFeature)((Object)f)).onServerSwitch(player), f.getFeatureName(), "Server Switch");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public void onQuit(@NotNull RedisPlayer disconnectedPlayer) {
        for (TabFeature f : this.values) {
            if (!(f instanceof RedisFeature)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((RedisFeature)((Object)f)).onQuit(disconnectedPlayer), f.getFeatureName(), "Player Quit");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            ((TrackedTabList)all.getTabList()).getExpectedDisplayNames().remove(disconnectedPlayer.getUniqueId());
        }
    }

    public void onVanishStatusChange(@NotNull RedisPlayer player) {
        for (TabFeature f : this.values) {
            if (!(f instanceof RedisFeature)) continue;
            TimedCaughtTask task = new TimedCaughtTask(TAB.getInstance().getCpu(), () -> ((RedisFeature)((Object)f)).onVanishStatusChange(player), f.getFeatureName(), "Vanish status change");
            if (f instanceof CustomThreaded) {
                ((CustomThreaded)((Object)f)).getCustomThread().execute(task);
                continue;
            }
            task.run();
        }
    }

    public synchronized void registerFeature(@NotNull String featureName, @NotNull TabFeature featureHandler) {
        this.features.put(featureName, featureHandler);
        this.values = this.features.values().toArray(new TabFeature[0]);
        if (featureHandler instanceof VanishListener) {
            TAB.getInstance().getPlaceholderManager().addUsedPlaceholder("%vanished%");
        }
        if (featureHandler instanceof GameModeListener) {
            TAB.getInstance().getPlaceholderManager().addUsedPlaceholder("%gamemode%");
        }
        if (featureHandler instanceof LatencyListener) {
            this.hasLatencyChangeListener = true;
        }
        if (featureHandler instanceof CommandListener) {
            this.hasCommandListener = true;
            this.listeningCommands.add(((CommandListener)((Object)featureHandler)).getCommand());
        }
    }

    public void unregisterFeature(@NotNull String featureName) {
        this.features.remove(featureName);
        this.values = this.features.values().toArray(new TabFeature[0]);
    }

    public boolean isFeatureEnabled(@NotNull String name) {
        return this.features.containsKey(name);
    }

    public <T extends TabFeature> T getFeature(@NotNull String name) {
        return (T)this.features.get(name);
    }

    public void loadFeaturesFromConfig() {
        TabFeature pwp;
        PipelineInjector inj;
        RedisSupport redis;
        Config config = TAB.getInstance().getConfiguration().getConfig();
        FeatureManager featureManager = TAB.getInstance().getFeatureManager();
        if (config.isEnableRedisHook() && (redis = TAB.getInstance().getPlatform().getRedisSupport()) != null) {
            TAB.getInstance().getFeatureManager().registerFeature("RedisBungee", redis);
        }
        if (config.isPipelineInjection() && (inj = TAB.getInstance().getPlatform().createPipelineInjector()) != null) {
            featureManager.registerFeature("injection", inj);
        }
        if (config.getPerWorldPlayerList() != null && (pwp = TAB.getInstance().getPlatform().getPerWorldPlayerList(config.getPerWorldPlayerList())) != null) {
            featureManager.registerFeature("PerWorldPlayerList", pwp);
        }
        if (config.getBossbar() != null) {
            featureManager.registerFeature("BossBar", new BossBarManagerImpl(config.getBossbar()));
        }
        if (config.getPingSpoof() != null) {
            featureManager.registerFeature("PingSpoof", new PingSpoof(config.getPingSpoof()));
        }
        if (config.getHeaderFooter() != null) {
            featureManager.registerFeature("HeaderFooter", new HeaderFooter(config.getHeaderFooter()));
        }
        if (config.isPreventSpectatorEffect()) {
            featureManager.registerFeature("SpectatorFix", new SpectatorFix());
        }
        if (config.getScoreboard() != null) {
            featureManager.registerFeature("ScoreBoard", new ScoreboardManagerImpl(config.getScoreboard()));
        }
        if (config.getPlayerlistObjective() != null) {
            featureManager.registerFeature("YellowNumber", new YellowNumber(config.getPlayerlistObjective()));
        }
        if (config.getBelowname() != null) {
            featureManager.registerFeature("BelowName", new BelowName(config.getBelowname()));
        }
        if (config.getSorting() != null) {
            featureManager.registerFeature("sorting", new Sorting(config.getSorting()));
        }
        if (config.getTablistFormatting() != null) {
            featureManager.registerFeature("PlayerList", new PlayerList(config.getTablistFormatting()));
        }
        if (config.getTeams() != null) {
            featureManager.registerFeature("NameTag16", new NameTag(config.getTeams()));
        }
        if (config.getLayout() != null) {
            featureManager.registerFeature("layout", new LayoutManagerImpl(config.getLayout()));
        }
        if (config.getGlobalPlayerList() != null && TAB.getInstance().getPlatform().isProxy()) {
            featureManager.registerFeature("GlobalPlayerList", new GlobalPlayerList(config.getGlobalPlayerList()));
        }
        featureManager.registerFeature("Nick", new NickCompatibility());
    }
}

