/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class SimpleComponent
extends TabComponent {
    @NotNull
    private final String text;

    @Override
    @NotNull
    public String toLegacyText() {
        return this.text;
    }

    @Override
    @NotNull
    public String toFlatText() {
        return this.text;
    }

    @Override
    @NotNull
    public String toRawText() {
        return this.text;
    }

    @Override
    @NotNull
    protected TextColor fetchLastColor() {
        if (this.text.isEmpty()) {
            return TextColor.legacy(EnumChatFormat.WHITE);
        }
        String last = EnumChatFormat.getLastColors(this.text);
        if (!last.isEmpty()) {
            char c = last.toCharArray()[1];
            for (EnumChatFormat e : EnumChatFormat.VALUES) {
                if (e.getCharacter() != c) continue;
                return TextColor.legacy(e);
            }
        }
        return TextColor.legacy(EnumChatFormat.WHITE);
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public SimpleComponent(@NotNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }
}

