/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.neznamy.tab.shared.chat.ChatModifier;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.chat.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuredComponent
extends TabComponent {
    @NotNull
    private String text = "";
    @NotNull
    private ChatModifier modifier = new ChatModifier();
    @Nullable
    private List<StructuredComponent> extra;
    @Nullable
    private String flatText;

    public StructuredComponent(@NotNull StructuredComponent component) {
        this.text = component.text;
        this.modifier = new ChatModifier(component.modifier);
        this.extra = component.extra == null ? null : component.extra.stream().map(StructuredComponent::new).collect(Collectors.toList());
    }

    public StructuredComponent(@NotNull String text, @NotNull List<StructuredComponent> components) {
        this.text = text;
        if (components.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty array of components");
        }
        this.extra = components;
    }

    @NotNull
    public List<StructuredComponent> getExtra() {
        if (this.extra == null) {
            return Collections.emptyList();
        }
        return this.extra;
    }

    @Override
    @NotNull
    public String toLegacyText() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    @Override
    @NotNull
    public String toFlatText() {
        if (this.flatText == null) {
            StringBuilder builder = new StringBuilder();
            TextColor color = this.modifier.getColor();
            if (color != null) {
                if (color.isLegacy()) {
                    builder.append((Object)color.getLegacyColor());
                } else {
                    builder.append("#").append(color.getHexCode());
                }
            }
            builder.append(this.modifier.getMagicCodes());
            builder.append(this.text);
            for (StructuredComponent child : this.getExtra()) {
                builder.append(child.toFlatText());
            }
            this.flatText = builder.toString();
        }
        return this.flatText;
    }

    @Override
    @NotNull
    public String toRawText() {
        StringBuilder builder = new StringBuilder(this.text);
        for (StructuredComponent extra : this.getExtra()) {
            builder.append(extra.toRawText());
        }
        return builder.toString();
    }

    @Override
    @NotNull
    protected TextColor fetchLastColor() {
        TextColor lastColor = this.modifier.getColor();
        for (StructuredComponent extra : this.getExtra()) {
            if (extra.modifier.getColor() == null) continue;
            lastColor = extra.modifier.getColor();
        }
        if (lastColor == null) {
            lastColor = TextColor.legacy(EnumChatFormat.WHITE);
        }
        return lastColor;
    }

    @NotNull
    private String append(@NotNull StringBuilder builder, @NotNull String previousFormatting) {
        String formatting = this.getFormatting();
        if (!formatting.equals(previousFormatting)) {
            builder.append(formatting);
        }
        builder.append(this.text);
        for (StructuredComponent component : this.getExtra()) {
            formatting = component.append(builder, formatting);
        }
        return formatting;
    }

    @NotNull
    private String getFormatting() {
        StringBuilder builder = new StringBuilder();
        if (this.modifier.getColor() != null) {
            if (this.modifier.getColor().getLegacyColor() == EnumChatFormat.WHITE) {
                builder.append((Object)EnumChatFormat.RESET);
            } else {
                builder.append((Object)this.modifier.getColor().getLegacyColor());
            }
        }
        builder.append(this.modifier.getMagicCodes());
        return builder.toString();
    }

    public StructuredComponent() {
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public ChatModifier getModifier() {
        return this.modifier;
    }

    @Nullable
    public String getFlatText() {
        return this.flatText;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }
}

