/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TextColor;
import me.neznamy.tab.shared.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.hook.AdventureHook;
import me.neznamy.tab.shared.util.FunctionWithException;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabComponent {
    private static final Pattern fontPattern = Pattern.compile("<font:(.*?)>(.*?)</font>");
    @Nullable
    private Object convertedModern;
    @Nullable
    private Object convertedLegacy;
    @Nullable
    private Component adventureModern;
    @Nullable
    private Component adventureLegacy;
    @Nullable
    private Object fixedFormat;
    @Nullable
    private Object textHolder;
    @Nullable
    private TextColor lastColor;

    @NotNull
    public <T> T convert(@NotNull ProtocolVersion clientVersion) {
        if (clientVersion.supportsRGB()) {
            if (this.convertedModern == null) {
                this.convertedModern = TAB.getInstance().getPlatform().convertComponent(this, true);
            }
            return (T)this.convertedModern;
        }
        if (this.convertedLegacy == null) {
            this.convertedLegacy = TAB.getInstance().getPlatform().convertComponent(this, false);
        }
        return (T)this.convertedLegacy;
    }

    @NotNull
    public Component toAdventure(@NotNull ProtocolVersion clientVersion) {
        if (clientVersion.supportsRGB()) {
            if (this.adventureModern == null) {
                this.adventureModern = AdventureHook.toAdventureComponent(this, true);
            }
            return this.adventureModern;
        }
        if (this.adventureLegacy == null) {
            this.adventureLegacy = AdventureHook.toAdventureComponent(this, false);
        }
        return this.adventureLegacy;
    }

    public <F, C> F toFixedFormat(@NotNull FunctionWithException<C, F> createFunction) {
        if (this.fixedFormat == null) {
            this.fixedFormat = createFunction.apply(this.convert(ProtocolVersion.LATEST_KNOWN_VERSION));
        }
        return (F)this.fixedFormat;
    }

    @NotNull
    public <T> T toTextHolder(@NotNull BiFunction<TabComponent, ProtocolVersion, T> convertFunction, @NotNull ProtocolVersion version) {
        if (this.textHolder == null) {
            this.textHolder = convertFunction.apply(this, version);
        }
        return (T)this.textHolder;
    }

    @NotNull
    public TextColor getLastColor() {
        if (this.lastColor == null) {
            this.lastColor = this.fetchLastColor();
        }
        return this.lastColor;
    }

    @NotNull
    public abstract String toLegacyText();

    @NotNull
    public abstract String toFlatText();

    @NotNull
    public abstract String toRawText();

    @NotNull
    protected abstract TextColor fetchLastColor();

    @NotNull
    public static TabComponent fromColoredText(@NotNull String originalText) {
        String remainingText = originalText;
        ArrayList<StructuredComponent> components = new ArrayList<StructuredComponent>();
        while (!remainingText.isEmpty()) {
            Matcher m = fontPattern.matcher(remainingText);
            if (m.find()) {
                if (m.start() > 0) {
                    components.addAll(TabComponent.toComponentArray(remainingText.substring(0, m.start()), null));
                }
                String match = m.group();
                components.addAll(TabComponent.toComponentArray(match.substring(match.indexOf(62) + 1, match.length() - 7), match.substring(6, match.indexOf(62))));
                remainingText = remainingText.substring(m.start() + match.length());
                continue;
            }
            components.addAll(TabComponent.toComponentArray(remainingText, null));
            break;
        }
        if (components.isEmpty()) {
            return new SimpleComponent("");
        }
        return new StructuredComponent("", components);
    }

    @NotNull
    private static List<StructuredComponent> toComponentArray(@NotNull String originalText, @Nullable String font) {
        String text = RGBUtils.getInstance().applyFormats(EnumChatFormat.color(originalText));
        ArrayList<StructuredComponent> components = new ArrayList<StructuredComponent>();
        StringBuilder builder = new StringBuilder();
        StructuredComponent component = new StructuredComponent();
        component.getModifier().setFont(font);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                EnumChatFormat format;
                if (++i >= text.length()) break;
                c = text.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((format = EnumChatFormat.getByChar(c)) == null) continue;
                if (builder.length() > 0) {
                    component.setText(builder.toString());
                    components.add(component);
                    component = new StructuredComponent(component);
                    component.setText("");
                    component.getModifier().setFont(font);
                    builder = new StringBuilder();
                }
                switch (format) {
                    case BOLD: {
                        component.getModifier().setBold(true);
                        break;
                    }
                    case ITALIC: {
                        component.getModifier().setItalic(true);
                        break;
                    }
                    case UNDERLINE: {
                        component.getModifier().setUnderlined(true);
                        break;
                    }
                    case STRIKETHROUGH: {
                        component.getModifier().setStrikethrough(true);
                        break;
                    }
                    case OBFUSCATED: {
                        component.getModifier().setObfuscated(true);
                        break;
                    }
                    case RESET: {
                        component = new StructuredComponent();
                        component.getModifier().setColor(TextColor.legacy(EnumChatFormat.WHITE));
                        component.getModifier().setFont(font);
                        break;
                    }
                    default: {
                        component = new StructuredComponent();
                        component.getModifier().setColor(TextColor.legacy(format));
                        component.getModifier().setFont(font);
                    }
                }
                continue;
            }
            if (c == '#' && text.length() > i + 6) {
                String hex = text.substring(i + 1, i + 7);
                if (TabComponent.isHexCode(hex)) {
                    TextColor color;
                    EnumChatFormat code;
                    EnumChatFormat enumChatFormat = code = text.length() - i >= 9 ? EnumChatFormat.getByChar(text.charAt(i + 8)) : null;
                    if (code != null && text.charAt(i + 7) == '|') {
                        color = new TextColor(hex, code);
                        i += 8;
                    } else {
                        color = new TextColor(hex);
                        i += 6;
                    }
                    if (builder.length() > 0) {
                        component.setText(builder.toString());
                        components.add(component);
                        builder = new StringBuilder();
                    }
                    component = new StructuredComponent();
                    component.getModifier().setColor(color);
                    component.getModifier().setFont(font);
                    continue;
                }
                builder.append('#');
                continue;
            }
            builder.append(c);
        }
        component.setText(builder.toString());
        components.add(component);
        return components;
    }

    private static boolean isHexCode(@NotNull String string) {
        for (int i = 0; i < string.length(); ++i) {
            if ("0123456789AaBbCcDdEeFf".indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

