/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import java.util.Arrays;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import org.jetbrains.annotations.NotNull;

public class TextColor {
    private static final TextColor[] legacyColors = (TextColor[])Arrays.stream(EnumChatFormat.VALUES).map(TextColor::new).toArray(TextColor[]::new);
    private int rgb = -1;
    private EnumChatFormat legacyColor;
    private String hexCode;
    private boolean legacyColorForced;
    private boolean legacy;

    public TextColor(@NotNull String hexCode) {
        this.hexCode = hexCode;
    }

    public TextColor(@NotNull String hexCode, @NotNull EnumChatFormat legacyColor) {
        this.hexCode = hexCode;
        this.legacyColorForced = true;
        this.legacyColor = legacyColor;
    }

    private TextColor(@NotNull EnumChatFormat legacyColor) {
        this.rgb = legacyColor.getRgb();
        this.legacyColor = legacyColor;
        this.hexCode = String.format("%06X", legacyColor.getRgb());
        this.legacyColorForced = true;
        this.legacy = true;
    }

    public TextColor(int red, int green, int blue) {
        this.rgb = (red << 16) + (green << 8) + blue;
    }

    private EnumChatFormat loadClosestColor() {
        double minMaxDist = 9999.0;
        EnumChatFormat closestColor = EnumChatFormat.WHITE;
        for (EnumChatFormat color : EnumChatFormat.VALUES) {
            int rDiff = Math.abs(color.getRed() - this.getRed());
            int gDiff = Math.abs(color.getGreen() - this.getGreen());
            int bDiff = Math.abs(color.getBlue() - this.getBlue());
            double maxDist = rDiff;
            if ((double)gDiff > maxDist) {
                maxDist = gDiff;
            }
            if ((double)bDiff > maxDist) {
                maxDist = bDiff;
            }
            if (!(maxDist < minMaxDist)) continue;
            minMaxDist = maxDist;
            closestColor = color;
        }
        return closestColor;
    }

    public int getRed() {
        return this.getRgb() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRgb() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRgb() & 0xFF;
    }

    public int getRgb() {
        if (this.rgb == -1) {
            this.rgb = Integer.parseInt(this.hexCode, 16);
        }
        return this.rgb;
    }

    @NotNull
    public EnumChatFormat getLegacyColor() {
        if (this.legacyColor == null) {
            this.legacyColor = this.loadClosestColor();
        }
        return this.legacyColor;
    }

    @NotNull
    public String getHexCode() {
        if (this.hexCode == null) {
            this.hexCode = String.format("%06X", this.rgb);
        }
        return this.hexCode;
    }

    public static TextColor legacy(@NotNull EnumChatFormat format) {
        return legacyColors[format.ordinal()];
    }

    public boolean isLegacyColorForced() {
        return this.legacyColorForced;
    }

    public boolean isLegacy() {
        return this.legacy;
    }
}

