/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.text.DecimalFormat;
import java.util.Map;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.cpu.CpuReport;
import me.neznamy.tab.shared.placeholders.types.TabPlaceholder;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCommand
extends SubCommand {
    private final DecimalFormat decimal3 = new DecimalFormat("#.###");
    private final char LINE_CHAR = (char)9553;

    public CpuCommand() {
        super("cpu", "tab.cpu");
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        CpuReport report = TAB.getInstance().getCPUManager().getLastReport();
        if (report == null) {
            if (TAB.getInstance().getCPUManager().enableTracking()) {
                this.sendMessage(sender, "&aCPU usage tracking has been enabled. Run the command again in 10 seconds to see the first results.");
            } else {
                this.sendMessage(sender, "&cPlease wait at least 10 seconds since running the command for the first time.");
            }
            return;
        }
        Map<String, Map<String, Float>> features = report.getFeatureUsage();
        this.sendMessage(sender, " ");
        this.sendMessage(sender, "&8&l\u2551&8&m             &r&8&l[ &bTAB CPU Stats &8&l]&r&8&l&m             ");
        this.sendMessage(sender, "&8&l\u2551 &6CPU stats from the last 10 seconds");
        this.sendMessage(sender, "&8&l\u2551&8&m                                                    ");
        this.sendMessage(sender, "&8&l\u2551 &6Top 5 placeholders:");
        this.printPlaceholders(sender, report.getPlaceholderUsage());
        this.sendMessage(sender, "&8&l\u2551&8&m                                                    ");
        if (sender != null) {
            this.sendToPlayer(sender, features);
        } else {
            this.sendToConsole(features);
        }
        this.sendMessage(sender, "&8&l\u2551&8&m                                                    ");
        this.sendMessage(sender, String.format("&8&l%s &6&lPlaceholders Total: &a&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(report.getPlaceholderUsageTotal()), 10.0f, 5.0f)));
        this.sendMessage(sender, String.format("&8&l%s &6&lPlugin internals: &a&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(report.getFeatureUsageTotal() - report.getPlaceholderUsageTotal()), 10.0f, 5.0f)));
        this.sendMessage(sender, String.format("&8&l%s &6&lTotal: &e&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(report.getFeatureUsageTotal()), 10.0f, 5.0f)));
        this.sendMessage(sender, "&8&l\u2551&8&m             &r&8&l[ &bTAB CPU Stats &8&l]&r&8&l&m             ");
        this.sendMessage(sender, " ");
    }

    private void printPlaceholders(@Nullable TabPlayer sender, @NotNull Map<String, Float> map) {
        int printCounter = 0;
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (printCounter++ == 5) break;
            String refresh = "";
            TabPlaceholder p = TAB.getInstance().getPlaceholderManager().getPlaceholder(entry.getKey());
            if (p.getRefresh() != -1) {
                refresh = " &8(" + p.getRefresh() + ")&7";
            }
            String colorized = entry.getKey().startsWith("%sync:") ? "&c" + this.decimal3.format(entry.getValue()) : this.colorize(this.decimal3.format(entry.getValue()), 1.0f, 0.3f);
            this.sendMessage(sender, String.format("&8&l%s &7%s - %s%%", Character.valueOf('\u2551'), entry.getKey() + refresh, colorized));
        }
    }

    private void sendToConsole(@NotNull Map<String, Map<String, Float>> features) {
        TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText(EnumChatFormat.color("&8&l\u2551 &6Features:")));
        for (Map.Entry<String, Map<String, Float>> entry : features.entrySet()) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText(EnumChatFormat.color(String.format("&8&l%s &7%s &7(%s%%&7):", Character.valueOf('\u2551'), entry.getKey(), this.colorize(this.decimal3.format(entry.getValue().values().stream().mapToDouble(Float::floatValue).sum()), 5.0f, 1.0f)))));
            for (Map.Entry<String, Float> type : entry.getValue().entrySet()) {
                TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText(EnumChatFormat.color(String.format("&8&l%s     &7%s - %s%%", Character.valueOf('\u2551'), type.getKey(), this.colorize(this.decimal3.format(type.getValue()), 5.0f, 1.0f)))));
            }
        }
    }

    private void sendToPlayer(@NotNull TabPlayer sender, @NotNull Map<String, Map<String, Float>> features) {
        this.sendMessage(sender, "&8&l\u2551 &6Features (execute from console for more info):");
        for (Map.Entry<String, Map<String, Float>> entry : features.entrySet()) {
            double featureTotal = entry.getValue().values().stream().mapToDouble(Float::floatValue).sum();
            String core = String.format("&8&l%s &7%s &7(%s%%&7):", Character.valueOf('\u2551'), entry.getKey(), this.colorize(this.decimal3.format(featureTotal), 5.0f, 1.0f));
            sender.sendMessage(TabComponent.fromColoredText(EnumChatFormat.color(core)));
        }
    }

    private String colorize(@NotNull String usage, float threshold1, float threshold2) {
        float percent = Float.parseFloat(usage.replace(",", "."));
        if (percent > threshold1) {
            return "&c" + usage;
        }
        if (percent > threshold2) {
            return "&e" + usage;
        }
        return "&a" + usage;
    }
}

