/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import me.neznamy.tab.shared.FeatureManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.MessageFile;
import me.neznamy.tab.shared.config.PropertyConfiguration;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import me.neznamy.tab.shared.config.file.YamlConfigurationFile;
import me.neznamy.tab.shared.config.file.YamlPropertyConfigurationFile;
import me.neznamy.tab.shared.config.files.Animations;
import me.neznamy.tab.shared.config.files.Config;
import me.neznamy.tab.shared.config.mysql.MySQL;
import me.neznamy.tab.shared.config.mysql.MySQLGroupConfiguration;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configs {
    private final Config config = new Config();
    private final Animations animations = new Animations();
    private final MessageFile messages = new MessageFile();
    private ConfigurationFile playerdata;
    private PropertyConfiguration groups;
    private PropertyConfiguration users;
    private MySQL mysql;

    public Configs() throws IOException {
        File errorLog = TAB.getInstance().getErrorManager().getErrorLog();
        if (errorLog.length() > 0x1000000L) {
            TAB.getInstance().getConfigHelper().startup().startupWarn(errorLog, "The file has reached its size limit (1MB). No new errors will be logged. Take a look at the existing logged errors, as they may have caused the plugin to not work properly in the past and if not fixed, will most likely cause problems in the future as well. If you are using latest version of the plugin, consider reporting them.");
        }
        if (this.config.getMysql() != null) {
            try {
                this.mysql = new MySQL(this.config.getMysql());
                this.mysql.openConnection();
                this.groups = new MySQLGroupConfiguration(this.mysql);
                this.users = new MySQLUserConfiguration(this.mysql);
                return;
            }
            catch (SQLException e) {
                TAB.getInstance().getErrorManager().mysqlConnectionFailed(e);
            }
        }
        this.groups = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/groups.yml"), new File(TAB.getInstance().getDataFolder(), "groups.yml"));
        this.users = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/users.yml"), new File(TAB.getInstance().getDataFolder(), "users.yml"));
    }

    public ConfigurationFile getPlayerDataFile() {
        if (this.playerdata == null) {
            File file = new File(TAB.getInstance().getDataFolder(), "playerdata.yml");
            try {
                if (file.exists() || file.createNewFile()) {
                    this.playerdata = new YamlConfigurationFile(null, file);
                }
            }
            catch (IOException e) {
                TAB.getInstance().getErrorManager().criticalError("Failed to load playerdata.yml", e);
            }
        }
        return this.playerdata;
    }

    public String getGroup(@NotNull Collection<String> serverGroups, @Nullable String element) {
        if (serverGroups.isEmpty() || element == null) {
            return element;
        }
        for (String worldGroup : serverGroups) {
            for (String definedWorld : worldGroup.toString().split(";")) {
                if (!(definedWorld.endsWith("*") ? element.toLowerCase().startsWith(definedWorld.substring(0, definedWorld.length() - 1).toLowerCase()) : (definedWorld.startsWith("*") ? element.toLowerCase().endsWith(definedWorld.substring(1).toLowerCase()) : element.equalsIgnoreCase(definedWorld)))) continue;
                return worldGroup.toString();
            }
        }
        return element;
    }

    public String getServerGroup(@NotNull Collection<String> serverGroups, @Nullable String server) {
        String globalGroup = this.tryServerGroup(serverGroups, server);
        if (globalGroup != null) {
            return globalGroup;
        }
        return this.getGroup(serverGroups, server);
    }

    @Nullable
    private String tryServerGroup(@NotNull Collection<String> serverGroups, @Nullable String server) {
        if (serverGroups.isEmpty() || server == null) {
            return null;
        }
        FeatureManager featureManager = TAB.getInstance().getFeatureManager();
        if (!featureManager.isFeatureEnabled("GlobalPlayerList")) {
            return null;
        }
        GlobalPlayerList t = (GlobalPlayerList)featureManager.getFeature("GlobalPlayerList");
        if (t == null) {
            return null;
        }
        String globalGroup = t.getServerGroupName(server);
        for (String serverGroup : serverGroups) {
            if (!globalGroup.equals(serverGroup.toString())) continue;
            return globalGroup;
        }
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public Animations getAnimations() {
        return this.animations;
    }

    public MessageFile getMessages() {
        return this.messages;
    }

    public ConfigurationFile getPlayerdata() {
        return this.playerdata;
    }

    public PropertyConfiguration getGroups() {
        return this.groups;
    }

    public PropertyConfiguration getUsers() {
        return this.users;
    }

    public MySQL getMysql() {
        return this.mysql;
    }
}

