/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import me.neznamy.tab.shared.config.file.YamlConfigurationFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Converter {
    public void convert2810to290(@NotNull ConfigurationFile animations) {
        if (animations.getValues().size() == 1 && animations.getValues().containsKey("animations")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 2.8.10 to 2.9.0"));
            animations.setValues(animations.getMap("animations"));
            animations.save();
        }
    }

    public void convert292to300(@NotNull ConfigurationFile currentConfig) throws IOException {
        File premiumFile;
        if (!currentConfig.hasConfigOption("change-nametag-prefix-suffix")) {
            return;
        }
        TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 2.9.2 to 3.0.0"));
        File folder = TAB.getInstance().getDataFolder();
        this.moveOldFiles();
        Files.createFile(new File(folder, "groups.yml").toPath(), new FileAttribute[0]);
        Files.createFile(new File(folder, "users.yml").toPath(), new FileAttribute[0]);
        Files.createFile(new File(folder, "config.yml").toPath(), new FileAttribute[0]);
        YamlConfigurationFile groups = new YamlConfigurationFile(null, new File(folder, "groups.yml"));
        YamlConfigurationFile users = new YamlConfigurationFile(null, new File(folder, "users.yml"));
        File oldConfigsFolder = new File(folder, "old_configs");
        File oldAnimations = new File(oldConfigsFolder, "animations.yml");
        if (oldAnimations.exists()) {
            Files.copy(oldAnimations.toPath(), new File(folder, "animations.yml").toPath(), new CopyOption[0]);
        }
        YamlConfigurationFile premiumConfig = (premiumFile = new File(oldConfigsFolder, "premiumconfig.yml")).exists() ? new YamlConfigurationFile(null, premiumFile) : null;
        File bossBarFile = new File(oldConfigsFolder, "bossbar.yml");
        if (!bossBarFile.exists()) {
            throw new IllegalStateException("Failed to convert configuration to v3: File bossbar.yml does not exist");
        }
        YamlConfigurationFile bossBar = new YamlConfigurationFile(null, bossBarFile);
        YamlConfigurationFile oldConfig = new YamlConfigurationFile(null, new File(oldConfigsFolder, "config.yml"));
        YamlConfigurationFile newConfig = new YamlConfigurationFile(null, new File(folder, "config.yml"));
        this.convertHeaderFooter(oldConfig, newConfig);
        this.convertTabListFormatting(oldConfig, newConfig);
        this.convertTeamOptions(oldConfig, newConfig, premiumConfig);
        this.convertYellowNumber(oldConfig, newConfig);
        this.convertBelowName(oldConfig, newConfig);
        this.convertBossBar(bossBar, newConfig);
        if (premiumConfig != null) {
            this.convertScoreboard(newConfig, premiumConfig);
        } else {
            this.createDefaultScoreboard(newConfig);
        }
        this.convertOtherOptions(oldConfig, newConfig, premiumConfig);
        this.convertGroupsAndUsers(oldConfig, groups, users);
        currentConfig.setValues(newConfig.getValues());
    }

    private void moveOldFiles() throws IOException {
        File folder = TAB.getInstance().getDataFolder();
        File oldFolder = new File(folder, "old_configs");
        Files.createDirectories(oldFolder.toPath(), new FileAttribute[0]);
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            if (!file.isFile()) continue;
            Files.move(file.toPath(), new File(folder.getPath() + File.separator + "old_configs" + File.separator + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void convertTeamOptions(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig, @Nullable ConfigurationFile premiumConfig) {
        String sortingPlaceholder;
        String sortingType;
        newConfig.set("scoreboard-teams.enabled", oldConfig.getBoolean("change-nametag-prefix-suffix", true));
        newConfig.set("scoreboard-teams.invisible-nametags", oldConfig.getBoolean("invisible-nametags", false));
        newConfig.set("scoreboard-teams.anti-override", oldConfig.getBoolean("anti-override.scoreboard-teams", true));
        newConfig.set("scoreboard-teams.enable-collision", oldConfig.getBoolean("enable-collision", true));
        newConfig.set("scoreboard-teams.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.nametag", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("scoreboard-teams.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.nametag", Collections.singletonList("disabledserver")));
        }
        List<Object> placeholderOrder = new ArrayList();
        if (premiumConfig != null) {
            newConfig.set("scoreboard-teams.case-sensitive-sorting", premiumConfig.getBoolean("case-sensitive-sorting", true));
            sortingType = premiumConfig.getString("sorting-type", "GROUPS");
            sortingPlaceholder = premiumConfig.getString("sorting-placeholder", "%some_level_maybe?%");
            placeholderOrder = premiumConfig.getStringList("placeholder-order", Arrays.asList("value1", "value2"));
        } else {
            newConfig.set("scoreboard-teams.case-sensitive-sorting", true);
            sortingType = oldConfig.getBoolean("sort-players-by-permissions", false) ? "GROUP_PERMISSIONS" : "GROUPS";
            sortingPlaceholder = "";
        }
        ArrayList<String> sortingTypes = new ArrayList<String>();
        for (String type : sortingType.split("_THEN_")) {
            if (type.equalsIgnoreCase("GROUPS") || type.equalsIgnoreCase("GROUP_PERMISSIONS")) {
                List<String> sortingList = oldConfig.getStringList("group-sorting-priority-list", Arrays.asList("owner", "admin", "mod", "helper", "builder", "premium", "player", "default"));
                StringBuilder groups = new StringBuilder(("GROUP_PERMISSIONS".equals(type) ? "PERMISSIONS" : "GROUPS") + ":");
                for (String group : sortingList) {
                    groups.append("GROUP_PERMISSIONS".equals(type) ? "tab.sort." : "");
                    groups.append(group.replace(" ", "|"));
                    if (sortingList.indexOf(group) == sortingList.size() - 1) continue;
                    groups.append(",");
                }
                sortingTypes.add(groups.toString());
                continue;
            }
            if (type.equalsIgnoreCase("PLACEHOLDER")) {
                sortingTypes.add("PLACEHOLDER:" + sortingPlaceholder + ":" + String.join((CharSequence)",", placeholderOrder));
                continue;
            }
            sortingTypes.add(type + ":" + sortingPlaceholder);
        }
        sortingTypes.add("PLACEHOLDER_A_TO_Z:%player%");
        newConfig.set("scoreboard-teams.sorting-types", sortingTypes);
    }

    private void convertTabListFormatting(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig) {
        newConfig.set("tablist-name-formatting.enabled", oldConfig.getBoolean("change-tablist-prefix-suffix", true));
        newConfig.set("tablist-name-formatting.anti-override", oldConfig.getBoolean("anti-override.tablist-names", true));
        newConfig.set("tablist-name-formatting.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.tablist-names", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("tablist-name-formatting.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.tablist-names", Collections.singletonList("disabledserver")));
        }
    }

    private void convertYellowNumber(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig) {
        newConfig.set("yellow-number-in-tablist.enabled", !oldConfig.getString("yellow-number-in-tablist", "%ping%").isEmpty());
        newConfig.set("yellow-number-in-tablist.value", oldConfig.getString("yellow-number-in-tablist", "%ping%"));
        newConfig.set("yellow-number-in-tablist.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.yellow-number", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("yellow-number-in-tablist.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.yellow-number", Collections.singletonList("disabledserver")));
        }
    }

    private void convertBelowName(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig) {
        newConfig.set("belowname-objective", oldConfig.getMap("classic-vanilla-belowname"));
        newConfig.set("belowname-objective.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.belowname", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("belowname-objective.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.belowname", Collections.singletonList("disabledserver")));
        }
    }

    private void convertBossBar(@NotNull ConfigurationFile bossBar, @NotNull ConfigurationFile newConfig) {
        newConfig.set("bossbar.enabled", bossBar.getBoolean("bossbar-enabled", false));
        newConfig.set("bossbar.toggle-command", bossBar.getString("bossbar-toggle-command", "/bossbar"));
        newConfig.set("bossbar.remember-toggle-choice", bossBar.getBoolean("remember-toggle-choice", false));
        newConfig.set("bossbar.hidden-by-default", bossBar.getBoolean("hidden-by-default", false));
        Map bars = bossBar.getMap("bars");
        Map perWorldBossBars = bossBar.getMap("per-world");
        ArrayList<String> activeBossBars = new ArrayList<String>(bossBar.getStringList("default-bars", new ArrayList<String>()));
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        for (Map.Entry entry : perWorldBossBars.entrySet()) {
            for (Object bar : (List)entry.getValue()) {
                if (!bars.containsKey(bar)) continue;
                activeBossBars.add((String)bar);
                if (((Map)bars.get(bar)).containsKey("display-condition")) {
                    ((Map)bars.get(bar)).put("display-condition", ((Map)bars.get(bar)).get("display-condition") + ";%" + separator + "%=" + (String)entry.getKey());
                    continue;
                }
                ((Map)bars.get(bar)).put("display-condition", "%" + separator + "%=" + (String)entry.getKey());
            }
        }
        for (Map.Entry entry : bars.entrySet()) {
            ((Map)entry.getValue()).put("announcement-bar", !activeBossBars.contains(entry.getKey()));
            ((Map)entry.getValue()).remove("permission-required");
        }
        newConfig.set("bossbar.default-bars", null);
        newConfig.set("bossbar.bars", bars);
    }

    private void convertScoreboard(@NotNull ConfigurationFile newConfig, @NotNull ConfigurationFile premiumConfig) {
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        newConfig.set("scoreboard", premiumConfig.getObject("scoreboard"));
        newConfig.set("scoreboard.permission-required-to-toggle", null);
        Map scoreboards = premiumConfig.getMap("scoreboards");
        Map perWorldScoreboards = premiumConfig.getMap("scoreboard.per-world");
        newConfig.set("scoreboard.default-scoreboard", null);
        newConfig.set("scoreboard.per-world", null);
        for (Map.Entry entry : perWorldScoreboards.entrySet()) {
            String world = (String)entry.getKey();
            String sb = (String)entry.getValue();
            if (!scoreboards.containsKey(sb)) continue;
            Map scoreboard = (Map)scoreboards.get(sb);
            if (scoreboard.containsKey("display-condition")) {
                scoreboard.put("display-condition", ((Map)scoreboards.get(sb)).get("display-condition") + ";%" + separator + "%=" + world);
                continue;
            }
            scoreboard.put("display-condition", "%" + separator + "%=" + world);
            scoreboards.remove(sb);
            HashMap reordered = new HashMap();
            reordered.put(sb, scoreboard);
            reordered.putAll(scoreboards);
            scoreboards = reordered;
        }
        newConfig.set("scoreboard.scoreboards", scoreboards);
    }

    private void createDefaultScoreboard(@NotNull ConfigurationFile newConfig) {
        newConfig.set("scoreboard.enabled", false);
        newConfig.set("scoreboard.toggle-command", "/sb");
        newConfig.set("scoreboard.remember-toggle-choice", false);
        newConfig.set("scoreboard.hidden-by-default", false);
        newConfig.set("scoreboard.use-numbers", false);
        newConfig.set("scoreboard.static-number", 0);
        newConfig.set("scoreboard.delay-on-join-milliseconds", 0);
        newConfig.set("scoreboard.scoreboards.admin.display-condition", "permission:tab.scoreboard.admin");
        newConfig.set("scoreboard.scoreboards.admin.title", "Admin scoreboard");
        newConfig.set("scoreboard.scoreboards.admin.lines", Arrays.asList("%animation:MyAnimation1%", "&6Online:", "* &eOnline&7: &f%online%&7", "* &eCurrent World&7: &f%worldonline%", "* &eStaff&7: &f%staffonline%", " ", "&6Server Info:", "* &bTPS&7: %tps%", "* &bUptime&7: &f%server_uptime%", "* &bMemory&7: &f%memory-used%&7/&4%memory-max%", "%animation:MyAnimation1%"));
        newConfig.set("scoreboard.scoreboards.scoreboard1.title", "Default");
        newConfig.set("scoreboard.scoreboards.scoreboard1.lines", Arrays.asList("%animation:MyAnimation1%", "&6My Stats:", "* &eKills&7: &f%statistic_player_kills%", "* &eDeaths&7: &f%statistic_deaths%", "* &eHealth&7: &f%health%", " ", "&6Personal Info:", "* &bRank&7: &f%group%", "* &bPing&7: &f%ping%&7ms", "* &bWorld&7: &f%world%", "%animation:MyAnimation1%"));
    }

    private void convertHeaderFooter(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig) {
        newConfig.set("header-footer.enabled", oldConfig.getBoolean("enable-header-footer", true));
        newConfig.set("header-footer.header", oldConfig.getStringList("header"));
        newConfig.set("header-footer.footer", oldConfig.getStringList("footer"));
        newConfig.set("header-footer.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.header-footer", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("header-footer.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.header-footer", Collections.singletonList("disabledserver")));
        }
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        Map perWorldSettings = oldConfig.getMap("per-" + separator + "-settings");
        LinkedHashMap headerFooterMap = new LinkedHashMap();
        for (Map.Entry worldEntry : new LinkedHashMap(perWorldSettings).entrySet()) {
            LinkedHashMap headerFooter = new LinkedHashMap();
            for (Map.Entry propertyValueEntry : new LinkedHashMap((Map)worldEntry.getValue()).entrySet()) {
                if (!((String)propertyValueEntry.getKey()).equalsIgnoreCase("header") && !((String)propertyValueEntry.getKey()).equalsIgnoreCase("footer")) continue;
                headerFooter.put((String)propertyValueEntry.getKey(), propertyValueEntry.getValue());
            }
            headerFooterMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), headerFooter);
        }
        newConfig.set("header-footer.per-" + separator, headerFooterMap);
    }

    private void convertOtherOptions(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile newConfig, @Nullable ConfigurationFile premiumConfig) {
        newConfig.set("prevent-spectator-effect.enabled", oldConfig.getBoolean("do-not-move-spectators", false));
        Map placeholders = oldConfig.getMap("placeholders");
        if (premiumConfig != null) {
            newConfig.set("placeholder-output-replacements", premiumConfig.getMap("placeholder-output-replacements"));
            newConfig.set("conditions", premiumConfig.getMap("conditions"));
        } else {
            newConfig.set("placeholder-output-replacements.%essentials_vanished%.yes", "&7| Vanished");
            newConfig.set("placeholder-output-replacements.%essentials_vanished%.no", "");
            newConfig.set("conditions.nick.conditions", Collections.singletonList("%player%=%essentials_nickname%"));
            newConfig.set("conditions.nick.yes", "%player%");
            newConfig.set("conditions.nick.no", "~%essentials_nickname%");
        }
        newConfig.set("placeholders", placeholders);
        newConfig.set("placeholderapi-refresh-intervals", oldConfig.getMap("placeholderapi-refresh-intervals"));
        newConfig.set("assign-groups-by-permissions", oldConfig.getBoolean("assign-groups-by-permissions", false));
        newConfig.set("primary-group-finding-list", oldConfig.getStringList("primary-group-finding-list", Arrays.asList("Owner", "Admin", "Mod", "Helper", "default")));
        newConfig.set("debug", oldConfig.getBoolean("debug", false));
        newConfig.set("mysql.enabled", false);
        newConfig.set("mysql.host", "127.0.0.1");
        newConfig.set("mysql.port", 3306);
        newConfig.set("mysql.database", "tab");
        newConfig.set("mysql.username", "user");
        newConfig.set("mysql.password", "password");
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("global-playerlist", oldConfig.getMap("global-playerlist"));
            newConfig.set("global-playerlist.update-latency", false);
            newConfig.set("use-bukkit-permissions-manager", false);
        } else {
            newConfig.set("per-world-playerlist", oldConfig.getMap("per-world-playerlist"));
        }
    }

    private void convertGroupsAndUsers(@NotNull ConfigurationFile oldConfig, @NotNull ConfigurationFile groups, @NotNull ConfigurationFile users) {
        groups.setValues(oldConfig.getMap("Groups"));
        users.setValues(oldConfig.getMap("Users"));
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        Map perWorldSettings = oldConfig.getMap("per-" + separator + "-settings");
        LinkedHashMap groupMap = new LinkedHashMap();
        LinkedHashMap userMap = new LinkedHashMap();
        LinkedHashMap worldMap = new LinkedHashMap(perWorldSettings);
        for (Map.Entry worldEntry : worldMap.entrySet()) {
            for (Map.Entry entry2 : new LinkedHashMap((Map)worldEntry.getValue()).entrySet()) {
                if (((String)entry2.getKey()).equalsIgnoreCase("Groups")) {
                    groupMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), entry2.getValue());
                    continue;
                }
                if (!((String)entry2.getKey()).equalsIgnoreCase("Users")) continue;
                userMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), entry2.getValue());
            }
        }
        groups.set("per-" + separator, groupMap);
        groups.set("_DEFAULT_", groups.getMap("_OTHER_"));
        groups.set("_OTHER_", null);
        users.set("per-" + separator, userMap);
        for (Map.Entry world : groups.getMap("per-" + separator).keySet()) {
            String gPath = "per-" + separator + "." + world;
            if (!groups.hasConfigOption(gPath + "._OTHER_")) continue;
            groups.set(gPath + "." + "_DEFAULT_", groups.getObject(gPath + "._OTHER_"));
            groups.set(gPath + "._OTHER_", null);
        }
    }

    private String translateWorldGroup(@NotNull ConfigurationFile oldConfig, @NotNull String group) {
        String oldSeparator = oldConfig.hasConfigOption("multi-world-separator") ? oldConfig.getString("multi-world-separator") : "-";
        return group.replace(oldSeparator, ";");
    }

    public void convert301to302(@NotNull ConfigurationFile config) {
        if (config.removeOption("placeholders.remove-strings")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 3.0.1 to 3.0.2"));
        }
    }

    public void convert332to400(@NotNull ConfigurationFile config) throws IOException {
        File layoutFile;
        if (config.hasConfigOption("fix-pet-names")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 3.3.2 to 4.0.0"));
            config.set("fix-pet-names", null);
            config.set("bossbar.disable-in-worlds", null);
            config.set("bossbar.disable-in-servers", null);
            config.set("scoreboard.disable-in-worlds", null);
            config.set("scoreboard.disable-in-servers", null);
            config.set("remove-ghost-players", null);
            config.set("global-playerlist.fill-profile-key", null);
        }
        Map intervals = config.getMap("placeholderapi-refresh-intervals");
        boolean updated = false;
        for (Map.Entry entry : new ArrayList(intervals.entrySet())) {
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            intervals.remove(entry.getKey());
            intervals.putAll((Map)value);
            updated = true;
        }
        if (updated) {
            config.save();
        }
        if ((layoutFile = new File(TAB.getInstance().getDataFolder(), "layout.yml")).exists()) {
            YamlConfigurationFile layout = new YamlConfigurationFile(null, layoutFile);
            config.set("layout", layout.getValues());
            Files.delete(layoutFile.toPath());
        }
        Consumer<Map> disabledConditionConverter = map -> {
            List worlds;
            ArrayList newConditions = new ArrayList();
            boolean update = false;
            if (map.containsKey("disable-in-worlds") && map.get("disable-in-worlds") instanceof List) {
                update = true;
                worlds = (List)map.get("disable-in-worlds");
                newConditions.addAll(worlds.stream().map(world -> "%world%=" + world).collect(Collectors.toList()));
            }
            if (map.containsKey("disable-in-servers") && map.get("disable-in-servers") instanceof List) {
                update = true;
                worlds = (List)map.get("disable-in-servers");
                newConditions.addAll(worlds.stream().map(server -> "%server%=" + server).collect(Collectors.toList()));
            }
            if (update) {
                map.remove("disable-in-worlds");
                map.remove("disable-in-servers");
                map.put("disable-condition", String.join((CharSequence)"|", newConditions));
                config.save();
            }
        };
        disabledConditionConverter.accept(config.getMap("header-footer"));
        disabledConditionConverter.accept(config.getMap("tablist-name-formatting"));
        disabledConditionConverter.accept(config.getMap("scoreboard-teams"));
        disabledConditionConverter.accept(config.getMap("yellow-number-in-tablist"));
        disabledConditionConverter.accept(config.getMap("belowname-objective"));
        config.removeOption("layout.hide-vanished-players");
    }

    public void convert409to410(@NotNull ConfigurationFile config) {
        if (config.hasConfigOption("yellow-number-in-tablist")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 4.0.9 to 4.1.0"));
            Map<String, String> section = config.getMap("yellow-number-in-tablist");
            section.put("fancy-value", "&7Ping: %ping%");
            config.set("yellow-number-in-tablist", null);
            config.set("playerlist-objective", section);
        }
        config.setIfMissing("belowname-objective.fancy-value-default", "NPC");
        config.setIfMissing("belowname-objective.fancy-value", "&c%health%");
        config.removeOption("tablist-name-formatting.align-tabsuffix-on-the-right");
        config.removeOption("tablist-name-formatting.character-width-overrides");
    }

    public void convert419to500(@NotNull ConfigurationFile config) {
        if (config.removeOption("scoreboard-teams.unlimited-nametag-mode")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 4.1.9 to 5.0.0"));
            config.removeOption("scoreboard.respect-other-plugins");
        }
        if (!config.hasConfigOption("global-playerlist.update-latency")) {
            config.set("global-playerlist.update-latency", false);
        }
    }

    public void convert501to502(@NotNull ConfigurationFile config) {
        if (config.rename("belowname-objective.number", "belowname-objective.value")) {
            TAB.getInstance().getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.YELLOW) + "Performing configuration conversion from 5.0.1 to 5.0.2"));
        }
        config.rename("belowname-objective.text", "belowname-objective.title");
        config.rename("belowname-objective.fancy-display-players", "belowname-objective.fancy-value");
        config.rename("belowname-objective.fancy-display-default", "belowname-objective.fancy-value-default");
    }
}

