/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.file;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.neznamy.tab.shared.TAB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationSection {
    @NotNull
    private final String file;
    @NotNull
    private final String section;
    @NotNull
    private final Map<Object, Object> map;

    public void checkForUnknownKey(@NotNull List<String> validProperties) {
        for (Object mapKey : this.map.keySet()) {
            if (validProperties.contains(mapKey.toString())) continue;
            this.startupWarn(String.format("Configuration section \"%s\" has unknown key \"%s\". Valid keys: %s", this.section, mapKey, validProperties));
        }
    }

    public void startupWarn(@NotNull String message) {
        TAB.getInstance().getConfigHelper().startup().startupWarn("[" + this.file + "] " + message);
    }

    public void hint(@NotNull String message) {
        TAB.getInstance().getConfigHelper().hint(this.file, message);
    }

    @Nullable
    public Boolean getBoolean(@NotNull String path) {
        return this.getNullable(path, Boolean.class);
    }

    public boolean getBoolean(@NotNull String path, boolean defaultValue) {
        return this.getRequired(path, defaultValue, Boolean.class);
    }

    @Nullable
    public Integer getInt(@NotNull String path) {
        return this.getNullable(path, Integer.class);
    }

    public int getInt(@NotNull String path, int defaultValue) {
        return this.getRequired(path, defaultValue, Integer.class);
    }

    @Nullable
    public Number getNumber(@NotNull String path) {
        return this.getNullable(path, Number.class);
    }

    @NotNull
    public Number getNumber(@NotNull String path, @NotNull Number defaultValue) {
        return this.getRequired(path, defaultValue, Number.class);
    }

    @Nullable
    public String getString(@NotNull String path) {
        return this.getNullable(path, String.class);
    }

    @NotNull
    public String getString(@NotNull String path, @NotNull String defaultValue) {
        return this.getRequired(path, defaultValue, String.class);
    }

    @Nullable
    public List<String> getStringList(@NotNull String path) {
        List list = this.getNullable(path, List.class);
        if (list == null) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.toList());
    }

    @NotNull
    public List<String> getStringList(@NotNull String path, @NotNull List<String> defaultValue) {
        List list = this.getRequired(path, defaultValue, List.class);
        return list.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Nullable
    public <K, V> Map<K, V> getMap(@NotNull String path) {
        return this.getNullable(path, Map.class);
    }

    @NotNull
    public <K, V> Map<K, V> getMap(@NotNull String path, @NotNull Map<?, ?> defaultValue) {
        return this.getRequired(path, defaultValue, Map.class);
    }

    @Nullable
    public Object getObject(@NotNull String path) {
        return this.getNullable(path, Object.class);
    }

    @NotNull
    public Object getObject(@NotNull String path, @NotNull Object defaultValue) {
        return this.getRequired(path, defaultValue, Object.class);
    }

    @Nullable
    private <T> T getNullable(@NotNull String path, @NotNull Class<T> clazz) {
        return this.evaluateNullable(this.get(path), path, clazz);
    }

    @Nullable
    private <T> T evaluateNullable(@Nullable Object value, @NotNull String path, @NotNull Class<T> clazz) {
        if (value != null && !clazz.isInstance(value)) {
            this.startupWarn("Configuration section \"" + this.section + "." + path + "\" is expected to be of type " + clazz.getSimpleName() + ", but was " + value.getClass().getSimpleName());
            return null;
        }
        return (T)value;
    }

    @NotNull
    private <T> T getRequired(@NotNull String path, @NotNull T defaultValue, @NotNull Class<T> clazz) {
        return this.evaluateRequired(this.get(path), path, defaultValue, clazz);
    }

    @NotNull
    private <T> T evaluateRequired(@Nullable Object value, @NotNull String path, @NotNull T defaultValue, @NotNull Class<T> clazz) {
        if (value == null) {
            this.startupWarn("Missing configuration section \"" + this.section + "." + path + "\" of type " + clazz.getSimpleName() + ", using default value " + defaultValue + ".");
            return defaultValue;
        }
        if (!clazz.isInstance(value)) {
            this.startupWarn("Configuration section \"" + this.section + "." + path + "\" is expected to be of type " + clazz.getSimpleName() + ", but was " + value.getClass().getSimpleName() + " (" + value + "). Using default value \"" + defaultValue + "\".");
            return defaultValue;
        }
        return (T)value;
    }

    @Nullable
    private Object get(@NotNull String key) {
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey().toString())) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    public Collection<Object> getKeys() {
        return this.map.keySet();
    }

    @NotNull
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        Map<Object, Object> map = this.getMap(path);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return new ConfigurationSection(this.file, this.section + "." + path, map);
    }

    public ConfigurationSection(@NotNull String file, @NotNull String section, @NotNull Map<Object, Object> map) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (section == null) {
            throw new NullPointerException("section is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.file = file;
        this.section = section;
        this.map = map;
    }
}

