/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.PropertyConfiguration;
import me.neznamy.tab.shared.config.file.YamlConfigurationFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlPropertyConfigurationFile
extends YamlConfigurationFile
implements PropertyConfiguration {
    private final String PER_SERVER = "per-server";
    private final String PER_WORLD = "per-world";
    private final String category;
    private final Collection<String> worldGroups = new ArrayList(this.getMap("per-world").keySet());
    private final Collection<String> serverGroups = new ArrayList(this.getMap("per-server").keySet());

    public YamlPropertyConfigurationFile(@Nullable InputStream source, @NotNull File destination) throws IOException {
        super(source, destination);
        this.category = destination.getName().contains("groups") ? "group" : "user";
        for (Map.Entry<String, Object> entry : this.getValues().entrySet()) {
            if (entry.getKey().equals("per-server")) {
                for (String server : this.serverGroups) {
                    for (String name : this.getMap("per-server." + server).keySet()) {
                        for (String property : this.getMap("per-server." + server + "." + name).keySet()) {
                            this.checkProperty(destination.getName(), this.category, name, property, server, null, true);
                        }
                    }
                }
                continue;
            }
            if (entry.getKey().equals("per-world")) {
                for (String world : this.worldGroups) {
                    for (String name : this.getMap("per-world." + world).keySet()) {
                        for (String property : this.getMap("per-world." + world + "." + name).keySet()) {
                            this.checkProperty(destination.getName(), this.category, name, property, null, world, true);
                        }
                    }
                }
                continue;
            }
            for (String property : this.getMap(entry.getKey()).keySet()) {
                this.checkProperty(destination.getName(), this.category, entry.getKey(), property, null, null, true);
            }
        }
    }

    @Override
    public void setProperty(@NotNull String name, @NotNull String property, @Nullable String server, @Nullable String world, @Nullable String value) {
        if (world != null) {
            this.set(String.format("%s.%s.%s.%s", "per-world", world, name, property), this.fromString(value));
        } else if (server != null) {
            this.set(String.format("%s.%s.%s.%s", "per-server", server, name, property), this.fromString(value));
        } else {
            this.set(String.format("%s.%s", name, property), this.fromString(value));
        }
    }

    @Override
    public String[] getProperty(@NotNull String name, @NotNull String property, @Nullable String server, @Nullable String world) {
        Object value = this.getObject(new String[]{"per-world", TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", world=" + world};
        }
        value = this.getObject(new String[]{"per-world", TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), "_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_" + ", world=" + world};
        }
        value = this.getObject(new String[]{"per-server", TAB.getInstance().getConfiguration().getServerGroup(this.serverGroups, server), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", server=" + server};
        }
        value = this.getObject(new String[]{"per-server", TAB.getInstance().getConfiguration().getServerGroup(this.serverGroups, server), "_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_" + ", server=" + server};
        }
        value = this.getObject(new String[]{name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name};
        }
        value = this.getObject(new String[]{"_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_"};
        }
        return new String[0];
    }

    @Override
    public void remove(@NotNull String name) {
        this.set(name, null);
        this.getMap("per-world").keySet().forEach(world -> this.set("per-world." + world + "." + name, null));
        this.getMap("per-server").keySet().forEach(server -> this.set("per-server." + server + "." + name, null));
    }

    @Override
    @NotNull
    public Map<String, Object> getGlobalSettings(@NotNull String name) {
        return this.getMap(name);
    }

    @Override
    @NotNull
    public Map<String, Map<String, Object>> getPerWorldSettings(@NotNull String name) {
        return this.convertMap(this.getMap("per-world"), name);
    }

    @Override
    @NotNull
    public Map<String, Map<String, Object>> getPerServerSettings(@NotNull String name) {
        return this.convertMap(this.getMap("per-server"), name);
    }

    @Override
    @NotNull
    public Set<String> getAllEntries() {
        HashSet<String> set = new HashSet<String>(this.values.keySet());
        set.remove("per-world");
        set.remove("per-server");
        Map perWorld = this.getMap("per-world");
        perWorld.values().forEach(m -> set.addAll(m.keySet()));
        Map perServer = this.getMap("per-server");
        perServer.values().forEach(m -> set.addAll(m.keySet()));
        return set;
    }
}

