/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.helper;

import java.io.File;
import java.util.Set;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.sorting.types.SortingType;
import org.jetbrains.annotations.NotNull;

public class StartupWarnPrinter {
    private int warnCount;

    public void invalidLayoutSkinDefinition(@NotNull String definition) {
        this.startupWarn("Invalid skin definition: \"" + definition + "\". Supported patterns are:", "#1 - \"player:<name>\" for skin of player with specified name", "#2 - \"mineskin:<id>\" for UUID of chosen skin from mineskin.org", "#3 - \"texture:<texture>\" for raw texture string");
    }

    public void invalidSortingTypeElement(@NotNull String element, @NotNull Set<String> validTypes) {
        this.startupWarn("\"" + element + "\" is not a valid sorting type element. Valid options are: " + validTypes + ".");
    }

    public void invalidSortingPlaceholder(@NotNull String placeholder, @NotNull SortingType type) {
        this.startupWarn("\"" + placeholder + "\" is not a valid placeholder for " + type.getClass().getSimpleName() + " sorting type");
    }

    public void invalidConditionPattern(@NotNull String conditionName, @NotNull String line) {
        this.startupWarn("Line \"" + line + "\" in condition " + conditionName + " is not a valid condition pattern.");
    }

    public void incompleteSortingLine(@NotNull String configuredLine) {
        this.startupWarn("Sorting line \"" + configuredLine + "\" is incomplete.");
    }

    public void startupWarn(String ... messages) {
        ++this.warnCount;
        for (String message : messages) {
            TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText(message));
        }
    }

    public void startupWarn(@NotNull File file, @NotNull String message) {
        ++this.warnCount;
        TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText("[" + file.getName() + "] " + message));
    }

    public void printWarnCount() {
        if (this.warnCount == 0) {
            return;
        }
        TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText("Found a total of " + this.warnCount + " issues."));
        this.warnCount = 0;
    }
}

